/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.modular_commands.api.command;

import dev.sympho.modular_commands.api.command.Invocation;
import dev.sympho.modular_commands.api.command.handler.InvocationHandler;
import dev.sympho.modular_commands.api.command.handler.ResultHandler;
import dev.sympho.modular_commands.api.command.parameter.Parameter;
import discord4j.rest.util.PermissionSet;
import java.util.Collections;
import java.util.List;
import org.checkerframework.dataflow.qual.Pure;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Command {
    @Pure
    public Scope scope();

    @Pure
    public boolean callable();

    @Pure
    public Invocation parent();

    @Pure
    public String name();

    @Pure
    default public Invocation invocation() {
        return this.parent().child(this.name());
    }

    @Pure
    public String displayName();

    @Pure
    public String description();

    @Pure
    public List<Parameter<?>> parameters();

    @Pure
    public PermissionSet requiredDiscordPermissions();

    @Pure
    public boolean requireParentPermissions();

    @Pure
    public boolean nsfw();

    @Pure
    public boolean botOwnerOnly();

    @Pure
    public boolean serverOwnerOnly();

    @Pure
    public boolean privateReply();

    @Pure
    public boolean inheritSettings();

    @Pure
    public boolean invokeParent();

    @Pure
    public InvocationHandler invocationHandler();

    @Pure
    default public List<? extends ResultHandler> resultHandlers() {
        return Collections.emptyList();
    }

    public static enum Scope {
        GLOBAL,
        GUILD;

    }
}

