/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.bot_utils.component;

import dev.sympho.bot_utils.access.AccessManager;
import dev.sympho.bot_utils.component.ComponentManager;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.interaction.ModalSubmitInteractionEvent;
import discord4j.core.object.component.TextInput;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public class ModalManager
extends ComponentManager<ModalSubmitInteractionEvent, ModalContext, HandlerFunction, Handler, HandlerEntry> {
    @SideEffectFree
    public ModalManager(GatewayDiscordClient client, AccessManager accessManager) {
        super(client, accessManager);
    }

    @SideEffectFree
    public static String makeId(String id, String args) {
        return ComponentManager.makeId(id, args);
    }

    @Override
    protected Class<ModalSubmitInteractionEvent> getEventType() {
        return ModalSubmitInteractionEvent.class;
    }

    @Override
    protected ModalContext makeContext(ModalSubmitInteractionEvent event, AccessManager accessManager) {
        return new ModalContext(event, accessManager);
    }

    @Override
    protected Mono<String> validateInteraction(ModalContext context, Handler handler) {
        return Mono.empty();
    }

    public final class ModalContext
    extends ComponentManager.ComponentContext<ModalSubmitInteractionEvent> {
        private final Map<String, TextInput> fields;

        private ModalContext(ModalSubmitInteractionEvent event, AccessManager accessManager) {
            super(event, accessManager);
            this.fields = event.getComponents(TextInput.class).stream().collect(Collectors.toUnmodifiableMap(TextInput::getCustomId, Function.identity()));
        }

        public TextInput getField(String fieldId) throws IllegalArgumentException {
            TextInput val = this.fields.get(fieldId);
            if (val == null) {
                throw new IllegalArgumentException("Input field " + fieldId + " not present");
            }
            return val;
        }

        public Collection<TextInput> getFields() {
            return this.fields.values();
        }
    }

    public static final class Handler
    extends Record
    implements ComponentManager.Handler<Handler, HandlerFunction> {
        private final HandlerFunction handler;

        public Handler(HandlerFunction handler) {
            this.handler = handler;
        }

        @Override
        public Handler compose(UnaryOperator<HandlerFunction> transform) {
            return new Handler((HandlerFunction)transform.apply(this.handler));
        }

        public static Handler of(HandlerFunction handler) {
            return new Handler(handler);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Handler.class, "handler", "handler"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Handler.class, "handler", "handler"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Handler.class, "handler", "handler"}, this, o);
        }

        @Override
        public HandlerFunction handler() {
            return this.handler;
        }
    }

    public static final class HandlerEntry
    extends Record
    implements ComponentManager.HandlerEntry<Handler> {
        private final String id;
        private final Handler handler;

        public HandlerEntry(String id, Handler handler) {
            this.id = id;
            this.handler = handler;
        }

        public static HandlerEntry of(String id, HandlerFunction handler) {
            return new HandlerEntry(id, Handler.of(handler));
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{HandlerEntry.class, "id;handler", "id", "handler"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{HandlerEntry.class, "id;handler", "id", "handler"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{HandlerEntry.class, "id;handler", "id", "handler"}, this, o);
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Handler handler() {
            return this.handler;
        }
    }

    @FunctionalInterface
    public static interface HandlerFunction
    extends ComponentManager.HandlerFunction<ModalContext> {
    }
}

