/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.bot_utils.component;

import dev.sympho.bot_utils.access.AccessManager;
import dev.sympho.bot_utils.access.AccessValidator;
import dev.sympho.bot_utils.access.ChannelAccessContext;
import dev.sympho.bot_utils.access.Group;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.interaction.ComponentInteractionEvent;
import discord4j.core.object.command.Interaction;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.MessageChannel;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;

public abstract class ComponentManager<E extends @NonNull ComponentInteractionEvent, C extends @NonNull ComponentContext<E>, HF extends @NonNull HandlerFunction<C>, H extends @NonNull Handler<H, HF>, HE extends @NonNull HandlerEntry<H>> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GatewayDiscordClient client;
    private final AccessManager accessManager;
    private final Map<String, H> handlers;
    private @Nullable Disposable active;

    @SideEffectFree
    public ComponentManager(GatewayDiscordClient client, AccessManager accessManager) {
        this.logger.debug("Configuring manager");
        this.client = client;
        this.accessManager = accessManager;
        this.handlers = new ConcurrentHashMap<String, H>();
        this.active = null;
    }

    public void register(String id, H handler) {
        this.logger.info("Registering handler with ID {}", (Object)id);
        if (this.handlers.put(id, handler) != null) {
            this.logger.warn("Replaced handler with ID {}", (Object)id);
        }
    }

    public void register(HE handler) {
        this.register(handler.id(), handler.handler());
    }

    public void unregister(String id) {
        this.logger.info("Unregistering handler with ID {}", (Object)id);
        if (this.handlers.remove(id) == null) {
            this.logger.error("Handler ID {} was not found", (Object)id);
        }
    }

    public void registerAll(Collection<HE> handlers) {
        handlers.forEach(this::register);
    }

    @SideEffectFree
    public static String makeId(String id, String args) {
        return "%s:%s".formatted(id, args);
    }

    @Pure
    protected abstract Class<E> getEventType();

    @SideEffectFree
    protected abstract C makeContext(E var1, AccessManager var2);

    @SideEffectFree
    protected abstract Mono<String> validateInteraction(C var1, H var2);

    @SideEffectFree
    private HandlerFunction<C> validationFailReporter(String error) {
        return (ctx, args) -> ctx.getEvent().reply(error).withEphemeral(Boolean.valueOf(true));
    }

    private Mono<?> handle(E event) {
        String customId = event.getCustomId();
        this.logger.debug("Received event with ID {}", (Object)customId);
        String[] call = customId.split(":", 2);
        String id = call[0];
        String args = call.length > 1 ? call[1] : "";
        Handler handler = (Handler)this.handlers.get(id);
        if (handler == null) {
            this.logger.error("Received interaction with unknown ID {}", (Object)id);
            return Mono.empty();
        }
        this.logger.trace("Found handler with ID {}", (Object)id);
        Object context = this.makeContext(event, this.accessManager);
        return this.validateInteraction(context, handler).map(this::validationFailReporter).defaultIfEmpty(handler.handler()).flatMap(h -> h.apply(context, args)).doOnError(e -> this.logger.error("Handler ID " + id + " threw an error", e)).onErrorComplete();
    }

    @PostConstruct
    public synchronized void start() {
        this.stop();
        this.logger.info("Starting handler");
        this.active = this.client.on(this.getEventType()).flatMap(this::handle).subscribe();
    }

    @PreDestroy
    public synchronized void stop() {
        if (this.active != null) {
            this.logger.info("Stopping handler");
            this.active.dispose();
            this.active = null;
        }
    }

    protected static interface HandlerEntry<H extends @NonNull Handler<H, ?>> {
        public String id();

        public H handler();
    }

    protected static interface Handler<SELF, HF extends @NonNull HandlerFunction<?>> {
        public HF handler();

        public SELF compose(UnaryOperator<HF> var1);
    }

    @FunctionalInterface
    protected static interface HandlerFunction<C extends @NonNull ComponentContext<?>>
    extends BiFunction<C, String, Mono<?>> {
        @Override
        public Mono<?> apply(C var1, String var2);
    }

    public static class ComponentContext<E extends @NonNull ComponentInteractionEvent>
    implements ChannelAccessContext,
    AccessValidator {
        private final E event;
        private final AccessValidator validator;

        protected ComponentContext(E event, AccessManager accessManager) {
            this.event = event;
            this.validator = accessManager.validator(this);
        }

        public E getEvent() {
            return this.event;
        }

        @Override
        public GatewayDiscordClient getClient() {
            return this.event.getClient();
        }

        @Override
        public Mono<Guild> getGuild() {
            return this.event.getInteraction().getGuild();
        }

        @Override
        public @Nullable Snowflake getGuildId() {
            return this.event.getInteraction().getGuildId().orElse(null);
        }

        @Override
        public User getUser() {
            return this.event.getInteraction().getUser();
        }

        @Override
        public Mono<Member> getMember() {
            return Mono.justOrEmpty((Optional)this.event.getInteraction().getMember());
        }

        @Override
        public Mono<Member> getMember(Snowflake guildId) {
            return this.event.getInteraction().getMember().map(m -> m).orElse(this.getUser()).asMember(guildId);
        }

        public Mono<MessageChannel> getChannel() {
            return this.event.getInteraction().getChannel();
        }

        @Override
        public Snowflake getChannelId() {
            return this.event.getInteraction().getChannelId();
        }

        @Pure
        public @Nullable Message getMessage() {
            return this.event.getMessage().orElse(null);
        }

        @Pure
        public Snowflake getMessageId() {
            return this.event.getMessageId();
        }

        @Pure
        public Interaction getInteraction() {
            return this.event.getInteraction();
        }

        @Override
        public Mono<Boolean> hasAccess(Group group) {
            return this.validator.hasAccess(group);
        }
    }
}

