/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.bot_utils.component;

import dev.sympho.bot_utils.access.AccessManager;
import dev.sympho.bot_utils.access.Group;
import dev.sympho.bot_utils.access.Groups;
import dev.sympho.bot_utils.access.NamedGroup;
import dev.sympho.bot_utils.component.ComponentManager;
import dev.sympho.reactor_utils.concurrent.AcquiredLock;
import dev.sympho.reactor_utils.concurrent.LockMap;
import dev.sympho.reactor_utils.concurrent.NonblockingLockMap;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.interaction.ButtonInteractionEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.UnaryOperator;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

public class ButtonManager
extends ComponentManager<ButtonInteractionEvent, ButtonContext, HandlerFunction, Handler, HandlerEntry> {
    private final LockMap<Snowflake> locks = new NonblockingLockMap();

    @SideEffectFree
    public ButtonManager(GatewayDiscordClient client, AccessManager accessManager) {
        super(client, accessManager);
    }

    @SideEffectFree
    public static String makeId(String id, String args) {
        return ComponentManager.makeId(id, args);
    }

    @Override
    public void register(HandlerEntry handler) {
        String id = handler.id();
        Handler handle = handler.handler();
        this.register(id, handler.mutex() ? handle.compose(this::mutex) : handle);
    }

    @SideEffectFree
    private Mono<String> checkPermission(ButtonContext context, Group group) {
        return context.validate(group).map(r -> {
            if (group instanceof NamedGroup) {
                NamedGroup g = (NamedGroup)group;
                return String.format("Only users in the %s group can use this button.", g.name());
            }
            return "You cannot use this button.";
        });
    }

    @Override
    protected Class<ButtonInteractionEvent> getEventType() {
        return ButtonInteractionEvent.class;
    }

    @Override
    protected ButtonContext makeContext(ButtonInteractionEvent event, AccessManager accessManager) {
        return new ButtonContext(event, accessManager);
    }

    @Override
    protected Mono<String> validateInteraction(ButtonContext context, Handler handler) {
        return this.checkPermission(context, handler.group());
    }

    public HandlerFunction mutex(HandlerFunction handler) {
        return (ctx, id) -> {
            AcquiredLock lock = this.locks.tryAcquire((Object)ctx.getMessageId());
            if (lock == null) {
                this.logger.debug("Aborted due to lock acquire fail");
                return ((ButtonInteractionEvent)ctx.getEvent()).reply().withEphemeral(Boolean.valueOf(true)).withContent("Sorry, please try again.");
            }
            return lock.releaseAfter(Mono.defer(() -> handler.apply(ctx, id)));
        };
    }

    public static final class HandlerEntry
    extends Record
    implements ComponentManager.HandlerEntry<Handler> {
        private final String id;
        private final Handler handler;
        private final boolean mutex;

        public HandlerEntry(String id, Handler handler, boolean mutex) {
            this.id = id;
            this.handler = handler;
            this.mutex = mutex;
        }

        public static HandlerEntry of(String id, HandlerFunction handler, boolean mutex, Group group) {
            return new HandlerEntry(id, Handler.of(handler, group), mutex);
        }

        public static HandlerEntry of(String id, HandlerFunction handler, boolean mutex) {
            return new HandlerEntry(id, Handler.of(handler), mutex);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{HandlerEntry.class, "id;handler;mutex", "id", "handler", "mutex"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{HandlerEntry.class, "id;handler;mutex", "id", "handler", "mutex"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{HandlerEntry.class, "id;handler;mutex", "id", "handler", "mutex"}, this, o);
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Handler handler() {
            return this.handler;
        }

        public boolean mutex() {
            return this.mutex;
        }
    }

    public static final class Handler
    extends Record
    implements ComponentManager.Handler<Handler, HandlerFunction> {
        private final HandlerFunction handler;
        private final Group group;

        public Handler(HandlerFunction handler, Group group) {
            this.handler = handler;
            this.group = group;
        }

        @Override
        public Handler compose(UnaryOperator<HandlerFunction> transform) {
            return new Handler((HandlerFunction)transform.apply(this.handler), this.group);
        }

        public static Handler of(HandlerFunction handler, Group group) {
            return new Handler(handler, group);
        }

        public static Handler of(HandlerFunction handler) {
            return Handler.of(handler, Groups.EVERYONE);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Handler.class, "handler;group", "handler", "group"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Handler.class, "handler;group", "handler", "group"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Handler.class, "handler;group", "handler", "group"}, this, o);
        }

        @Override
        public HandlerFunction handler() {
            return this.handler;
        }

        public Group group() {
            return this.group;
        }
    }

    public final class ButtonContext
    extends ComponentManager.ComponentContext<ButtonInteractionEvent> {
        private ButtonContext(ButtonInteractionEvent event, AccessManager accessManager) {
            super(event, accessManager);
        }
    }

    @FunctionalInterface
    public static interface HandlerFunction
    extends ComponentManager.HandlerFunction<ButtonContext> {
    }
}

