/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.bot_utils.access;

import dev.sympho.bot_utils.access.AccessContext;
import dev.sympho.bot_utils.access.ChannelAccessContext;
import dev.sympho.bot_utils.access.Group;
import dev.sympho.bot_utils.access.GuildGroup;
import dev.sympho.bot_utils.access.NamedGroup;
import dev.sympho.bot_utils.access.NamedGuildGroup;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.ApplicationInfo;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.PartialMember;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.rest.util.Permission;
import discord4j.rest.util.PermissionSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class Groups {
    public static final NamedGuildGroup EVERYONE = Groups.named((AccessContext ctx) -> Mono.just((Object)true), "Everyone");
    public static final NamedGuildGroup NOBODY = Groups.named((AccessContext ctx) -> Mono.just((Object)false), "Nobody");
    public static final NamedGuildGroup ADMINS = Groups.named(Groups.hasGuildPermissions(PermissionSet.of((Permission[])new Permission[]{Permission.ADMINISTRATOR})), "Administrators");
    public static final NamedGuildGroup SERVER_OWNER = Groups.named((AccessContext ctx) -> ctx.getGuild().map(Guild::getOwnerId).map(arg_0 -> ((Snowflake)ctx.getUser().getId()).equals(arg_0)), "Server Owner");
    public static final NamedGuildGroup BOT_OWNER = Groups.named((AccessContext ctx) -> ctx.getClient().getApplicationInfo().map(ApplicationInfo::getOwnerId).map(arg_0 -> ((Snowflake)ctx.getUser().getId()).equals(arg_0)), "Bot Owner");
    public static final NamedGuildGroup BOOSTER = Groups.named((AccessContext ctx) -> ctx.getMember().map(PartialMember::getPremiumTime).map(Optional::isPresent).defaultIfEmpty((Object)false), "Boosters");

    private Groups() {
    }

    public static NamedGroup named(Group group, String name) {
        return new Named(group, name);
    }

    public static NamedGuildGroup named(GuildGroup group, String name) {
        return new NamedGuild(group, name);
    }

    public static GuildGroup remote(GuildGroup group, Mono<Snowflake> guild) {
        return new Remote(group, guild);
    }

    public static NamedGuildGroup remote(NamedGuildGroup group, Mono<Snowflake> guild) {
        return Groups.named(Groups.remote((GuildGroup)group, guild), group.name());
    }

    public static GuildGroup remote(GuildGroup group, Supplier<Snowflake> guild) {
        return Groups.remote(group, (Mono<Snowflake>)Mono.fromSupplier(guild));
    }

    public static NamedGuildGroup remote(NamedGuildGroup group, Supplier<Snowflake> guild) {
        return Groups.remote(group, (Mono<Snowflake>)Mono.fromSupplier(guild));
    }

    public static GuildGroup remote(GuildGroup group, Snowflake guild) {
        return Groups.remote(group, (Mono<Snowflake>)Mono.just((Object)guild));
    }

    public static NamedGuildGroup remote(NamedGuildGroup group, Snowflake guild) {
        return Groups.remote(group, (Mono<Snowflake>)Mono.just((Object)guild));
    }

    public static Group any(Flux<Group> groups) {
        return ctx -> groups.flatMap(g -> g.belongs(ctx)).any(Boolean::booleanValue);
    }

    public static Group any(Stream<Group> groups) {
        return Groups.any((Flux<Group>)Flux.fromStream(groups));
    }

    public static Group any(Iterable<Group> groups) {
        return Groups.any((Flux<Group>)Flux.fromIterable(groups));
    }

    public static Group any(Group ... groups) {
        return Groups.any((Flux<Group>)Flux.fromArray((Object[])groups));
    }

    public static GuildGroup any(GuildGroup ... groups) {
        return Groups.anyGuild(groups);
    }

    public static GuildGroup anyGuild(Flux<GuildGroup> groups) {
        return ctx -> groups.flatMap(g -> g.belongs(ctx)).any(Boolean::booleanValue);
    }

    public static GuildGroup anyGuild(Stream<GuildGroup> groups) {
        return Groups.anyGuild((Flux<GuildGroup>)Flux.fromStream(groups));
    }

    public static GuildGroup anyGuild(Iterable<GuildGroup> groups) {
        return Groups.anyGuild((Flux<GuildGroup>)Flux.fromIterable(groups));
    }

    public static GuildGroup anyGuild(GuildGroup ... groups) {
        return Groups.anyGuild((Flux<GuildGroup>)Flux.fromArray((Object[])groups));
    }

    public static Group all(Flux<Group> groups) {
        return ctx -> groups.flatMap(g -> g.belongs(ctx)).all(Boolean::booleanValue);
    }

    public static Group all(Stream<Group> groups) {
        return Groups.all((Flux<Group>)Flux.fromStream(groups));
    }

    public static Group all(Iterable<Group> groups) {
        return Groups.all((Flux<Group>)Flux.fromIterable(groups));
    }

    public static Group all(Group ... groups) {
        return Groups.all((Flux<Group>)Flux.fromArray((Object[])groups));
    }

    public static GuildGroup all(GuildGroup ... groups) {
        return Groups.allGuild(groups);
    }

    public static GuildGroup allGuild(Flux<GuildGroup> groups) {
        return ctx -> groups.flatMap(g -> g.belongs(ctx)).all(Boolean::booleanValue);
    }

    public static GuildGroup allGuild(Stream<GuildGroup> groups) {
        return Groups.allGuild((Flux<GuildGroup>)Flux.fromStream(groups));
    }

    public static GuildGroup allGuild(Iterable<GuildGroup> groups) {
        return Groups.allGuild((Flux<GuildGroup>)Flux.fromIterable(groups));
    }

    public static GuildGroup allGuild(GuildGroup ... groups) {
        return Groups.allGuild((Flux<GuildGroup>)Flux.fromArray((Object[])groups));
    }

    public static GuildGroup isUser(Mono<Snowflake> user) {
        return ctx -> user.map(arg_0 -> ((Snowflake)ctx.getUser().getId()).equals(arg_0));
    }

    public static GuildGroup isUser(Supplier<Snowflake> user) {
        return Groups.isUser((Mono<Snowflake>)Mono.fromSupplier(user));
    }

    public static GuildGroup isUser(Snowflake user) {
        return Groups.isUser((Mono<Snowflake>)Mono.just((Object)user));
    }

    public static GuildGroup inWhitelist(Flux<Snowflake> users) {
        return ctx -> users.any(arg_0 -> ((Snowflake)ctx.getUser().getId()).equals(arg_0));
    }

    public static GuildGroup inWhitelist(Mono<? extends Collection<Snowflake>> users) {
        return ctx -> users.map(u -> u.contains(ctx.getUser().getId()));
    }

    public static GuildGroup inWhitelist(Supplier<? extends Collection<Snowflake>> users) {
        return Groups.inWhitelist((Mono<? extends Collection<Snowflake>>)Mono.fromSupplier(users));
    }

    public static GuildGroup inWhitelist(Collection<Snowflake> users) {
        Set<Snowflake> allowed = Set.copyOf(users);
        return Groups.inWhitelist((Mono<? extends Collection<Snowflake>>)Mono.just(allowed));
    }

    public static GuildGroup inWhitelist(Snowflake ... users) {
        return Groups.inWhitelist(Arrays.asList(users));
    }

    public static GuildGroup hasRole(Mono<Snowflake> role) {
        return ctx -> {
            Flux roles = ctx.getMember().flatMapMany(PartialMember::getRoles).map(Role::getId);
            return role.flatMap(r -> roles.any(arg_0 -> ((Snowflake)r).equals(arg_0)));
        };
    }

    public static GuildGroup hasRole(Supplier<Snowflake> role) {
        return Groups.hasRole((Mono<Snowflake>)Mono.fromSupplier(role));
    }

    public static GuildGroup hasRole(Snowflake role) {
        return Groups.hasRole((Mono<Snowflake>)Mono.just((Object)role));
    }

    public static GuildGroup hasRolesAny(Mono<? extends Collection<Snowflake>> roles) {
        return ctx -> {
            Flux has = ctx.getMember().flatMapMany(PartialMember::getRoles).map(Role::getId);
            return roles.flatMap(r -> has.any(r::contains));
        };
    }

    public static GuildGroup hasRolesAny(Flux<Snowflake> roles) {
        Mono allowed = roles.collect(Collectors.toSet());
        return Groups.hasRolesAny((Mono<? extends Collection<Snowflake>>)allowed);
    }

    public static GuildGroup hasRolesAny(Supplier<? extends Collection<Snowflake>> roles) {
        return Groups.hasRolesAny((Mono<? extends Collection<Snowflake>>)Mono.fromSupplier(roles));
    }

    public static GuildGroup hasRolesAny(Collection<Snowflake> roles) {
        Set<Snowflake> allowed = Set.copyOf(roles);
        return Groups.hasRolesAny((Mono<? extends Collection<Snowflake>>)Mono.just(allowed));
    }

    public static GuildGroup hasRolesAny(Snowflake ... roles) {
        return Groups.hasRolesAny(Arrays.asList(roles));
    }

    public static GuildGroup hasRolesAll(Flux<Snowflake> roles) {
        return ctx -> {
            Mono has = ctx.getMember().flatMapMany(PartialMember::getRoles).map(Role::getId).collect(Collectors.toSet());
            return has.flatMap(r -> roles.all(r::contains));
        };
    }

    public static GuildGroup hasRolesAll(Mono<? extends Collection<Snowflake>> roles) {
        return ctx -> {
            Mono has = ctx.getMember().flatMapMany(PartialMember::getRoles).map(Role::getId).collect(Collectors.toSet());
            return Mono.zip((Mono)has, (Mono)roles).map(t -> ((Set)t.getT1()).containsAll((Collection)t.getT2()));
        };
    }

    public static GuildGroup hasRolesAll(Supplier<? extends Collection<Snowflake>> roles) {
        return Groups.hasRolesAll((Mono<? extends Collection<Snowflake>>)Mono.fromSupplier(roles));
    }

    public static GuildGroup hasRolesAll(Collection<Snowflake> roles) {
        Set<Snowflake> required = Set.copyOf(roles);
        return Groups.hasRolesAll((Mono<? extends Collection<Snowflake>>)Mono.just(required));
    }

    public static GuildGroup hasRolesAll(Snowflake ... roles) {
        return Groups.hasRolesAll(Arrays.asList(roles));
    }

    public static GuildGroup hasGuildPermissions(Mono<PermissionSet> permissions) {
        return ctx -> ctx.getMember().flatMap(PartialMember::getBasePermissions).flatMap(p -> permissions.map(arg_0 -> p.containsAll(arg_0))).defaultIfEmpty((Object)true);
    }

    public static GuildGroup hasGuildPermissions(Supplier<PermissionSet> permissions) {
        return Groups.hasGuildPermissions((Mono<PermissionSet>)Mono.fromSupplier(permissions));
    }

    public static GuildGroup hasGuildPermissions(PermissionSet permissions) {
        return Groups.hasGuildPermissions((Mono<PermissionSet>)Mono.just((Object)permissions));
    }

    public static Group hasChannelPermissions(Mono<PermissionSet> permissions) {
        return ctx -> ctx.getChannel().ofType(GuildChannel.class).flatMap(c -> c.getEffectivePermissions(ctx.getUser().getId())).flatMap(p -> permissions.map(arg_0 -> p.containsAll(arg_0))).defaultIfEmpty((Object)true);
    }

    public static Group hasChannelPermissions(Supplier<PermissionSet> permissions) {
        return Groups.hasChannelPermissions((Mono<PermissionSet>)Mono.fromSupplier(permissions));
    }

    public static Group hasChannelPermissions(PermissionSet permissions) {
        return Groups.hasChannelPermissions((Mono<PermissionSet>)Mono.just((Object)permissions));
    }

    private record Named(Group group, String name) implements NamedGroup
    {
        @Override
        public Mono<Boolean> belongs(ChannelAccessContext context) {
            return this.group.belongs(context);
        }
    }

    private record NamedGuild(GuildGroup group, String name) implements NamedGuildGroup
    {
        @Override
        public Mono<Boolean> belongs(AccessContext context) {
            return this.group.belongs(context);
        }
    }

    private record Remote(GuildGroup group, Mono<Snowflake> remoteGuild) implements GuildGroup
    {
        @Override
        public Mono<Boolean> belongs(AccessContext context) {
            return this.remoteGuild.map(context::asGuild).switchIfEmpty(Mono.error(() -> new IllegalStateException("No remote guild provided"))).flatMap(this.group::belongs);
        }
    }
}

