/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.bot_utils.access;

import dev.sympho.bot_utils.access.AccessValidator;
import dev.sympho.bot_utils.access.ChannelAccessContext;
import dev.sympho.bot_utils.access.Group;
import org.checkerframework.dataflow.qual.SideEffectFree;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface AccessManager {
    public AccessValidator validator(ChannelAccessContext var1);

    @SideEffectFree
    public static AccessManager alwaysAllow() {
        return ctx -> group -> Mono.just((Object)true);
    }

    @SideEffectFree
    public static AccessManager alwaysDeny() {
        return ctx -> group -> Mono.just((Object)false);
    }

    @SideEffectFree
    public static AccessManager basic() {
        return ctx -> group -> group.belongs(ctx);
    }

    @SideEffectFree
    public static AccessManager overridable(Group overrideGroup) {
        return ctx -> group -> group.belongs(ctx).filter(Boolean::booleanValue).switchIfEmpty(Mono.defer(() -> overrideGroup.belongs(ctx))).defaultIfEmpty((Object)false);
    }
}

