/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.bot_utils;

import dev.sympho.bot_utils.access.Group;
import dev.sympho.bot_utils.access.Groups;
import dev.sympho.bot_utils.access.NamedGroup;
import dev.sympho.bot_utils.component.ButtonManager;
import discord4j.core.event.domain.interaction.ButtonInteractionEvent;
import discord4j.core.object.component.ActionComponent;
import discord4j.core.object.component.ActionRow;
import discord4j.core.object.component.Button;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.InteractionApplicationCommandCallbackSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple3;
import reactor.util.function.Tuples;

public class PaginationManager {
    public static final String BUTTON_ID_UPDATE = "page-update";
    public static final String BUTTON_ID_DISPLAY = "page-display";
    private static final ReactionEmoji BUTTON_LABEL_PREVIOUS = ReactionEmoji.unicode((String)"\u25c0\ufe0f");
    private static final ReactionEmoji BUTTON_LABEL_NEXT = ReactionEmoji.unicode((String)"\u25b6\ufe0f");
    private static final ReactionEmoji BUTTON_LABEL_REFRESH = ReactionEmoji.unicode((String)"\ud83d\udd01");
    private static final String ARG_SEPARATOR = ":";
    private static final Logger LOGGER = LoggerFactory.getLogger(PaginationManager.class);
    private final Map<String, Paginator> paginators = new HashMap<String, Paginator>();

    private String encode(String id, @NonNegative int index, String args) {
        String pageStr = String.valueOf(index);
        return args.isEmpty() ? String.join((CharSequence)ARG_SEPARATOR, id, pageStr) : String.join((CharSequence)ARG_SEPARATOR, id, pageStr, args);
    }

    private Tuple3<String, @NonNegative Integer, String> decode(String arg) {
        String args;
        String[] s = arg.split(ARG_SEPARATOR, 3);
        if (s.length < 2) {
            throw new IllegalArgumentException("Not a valid arg: " + arg);
        }
        String id = s[0];
        int index = Integer.parseInt(s[1]);
        String string = args = s.length > 2 ? s[2] : "";
        if (index < 0) {
            throw new IllegalArgumentException("Arg has negative index");
        }
        return Tuples.of((Object)id, (Object)index, (Object)args);
    }

    public synchronized Paginator register(String id, @Nullable Group requiredGroup, PageGenerator generator) throws IllegalArgumentException {
        if (this.paginators.containsKey(id)) {
            throw new IllegalArgumentException("ID already in use");
        }
        LOGGER.info("Registering paginator {}", (Object)id);
        Paginator paginator = new Paginator(generator, id, Objects.requireNonNullElse(requiredGroup, Groups.EVERYONE));
        this.paginators.put(id, paginator);
        return paginator;
    }

    public Paginator register(String id, PageGenerator generator) {
        return this.register(id, null, generator);
    }

    public ButtonManager.HandlerEntry pageUpdateHandler() {
        return ButtonManager.HandlerEntry.of(BUTTON_ID_UPDATE, (ctx, arg) -> {
            Tuple3<String, Integer, String> decoded = this.decode(arg);
            String id = (String)decoded.getT1();
            int page = (Integer)decoded.getT2();
            String args = (String)decoded.getT3();
            Paginator paginator = this.paginators.get(id);
            if (paginator == null) {
                return ((ButtonInteractionEvent)ctx.getEvent()).reply("Page type not recognized").withEphemeral(Boolean.valueOf(true));
            }
            return paginator.requiredGroup.belongs(ctx).flatMap(b -> {
                ButtonInteractionEvent event = (ButtonInteractionEvent)ctx.getEvent();
                if (b.booleanValue()) {
                    return paginator.generatePage(page, args).flatMap(arg_0 -> ((ButtonInteractionEvent)event).edit(arg_0));
                }
                Group patt6921$temp = paginator.requiredGroup;
                if (patt6921$temp instanceof NamedGroup) {
                    NamedGroup g = (NamedGroup)patt6921$temp;
                    return event.reply(String.format("You must be part of the %s group to change the page.", g.name()));
                }
                return event.reply("You do not have permissions to change the page.");
            });
        }, true);
    }

    public final class Paginator {
        private final PageGenerator generator;
        private final String id;
        private final Group requiredGroup;

        private Paginator(PageGenerator generator, String id, Group requiredGroup) {
            this.generator = generator;
            this.id = id;
            this.requiredGroup = requiredGroup;
        }

        private InteractionApplicationCommandCallbackSpec renderPage(PageData data) {
            LOGGER.trace("Rendering page {}/{}/{}", new Object[]{this.id, data.args(), data.index()});
            Button buttonPrev = data.index() <= 0 ? Button.primary((String)"page-update-", (ReactionEmoji)BUTTON_LABEL_PREVIOUS).disabled() : Button.primary((String)ButtonManager.makeId(PaginationManager.BUTTON_ID_UPDATE, PaginationManager.this.encode(this.id, data.index() - 1, data.args())), (ReactionEmoji)BUTTON_LABEL_PREVIOUS);
            Button buttonNext = data.index() >= data.pageCount() - 1 ? Button.primary((String)"page-update+", (ReactionEmoji)BUTTON_LABEL_NEXT).disabled() : Button.primary((String)ButtonManager.makeId(PaginationManager.BUTTON_ID_UPDATE, PaginationManager.this.encode(this.id, data.index() + 1, data.args())), (ReactionEmoji)BUTTON_LABEL_NEXT);
            ActionRow navBar = ActionRow.of((ActionComponent[])new ActionComponent[]{buttonPrev, Button.secondary((String)ButtonManager.makeId(PaginationManager.BUTTON_ID_UPDATE, PaginationManager.this.encode(this.id, data.index(), data.args())), (ReactionEmoji)BUTTON_LABEL_REFRESH), Button.secondary((String)PaginationManager.BUTTON_ID_DISPLAY, (String)"%d/%d".formatted(data.index() + 1, data.pageCount())).disabled(), buttonNext});
            return InteractionApplicationCommandCallbackSpec.builder().addEmbed(data.content()).addComponent((LayoutComponent)navBar).addAllComponents(data.components()).ephemeral(Boolean.valueOf(false)).build();
        }

        private Mono<InteractionApplicationCommandCallbackSpec> generatePage(@NonNegative int index, String args) throws IllegalArgumentException {
            if (index < 0) {
                throw new IllegalArgumentException("Negative indices not allowed");
            }
            return this.generator.generatePage(index, args).map(this::renderPage);
        }

        public Mono<InteractionApplicationCommandCallbackSpec> generateFirst(String args) {
            return this.generatePage(0, args);
        }
    }

    @FunctionalInterface
    public static interface PageGenerator {
        public Mono<PageData> generatePage(@NonNegative int var1, String var2);
    }

    public record PageData(String args, @NonNegative int index, @NonNegative int pageCount, EmbedCreateSpec content, List<LayoutComponent> components) {
        public static final int MAX_ROWS = 4;

        public PageData(String args, @NonNegative int index, @NonNegative int pageCount, EmbedCreateSpec content, List<LayoutComponent> components) {
            if (components.size() > 4) {
                throw new IllegalArgumentException("Too many component rows");
            }
        }

        public static PageData of(String args, @NonNegative int index, @NonNegative int pageCount, EmbedCreateSpec content, List<LayoutComponent> components) {
            return new PageData(args, index, pageCount, content, components);
        }

        public static PageData of(String args, @NonNegative int index, @NonNegative int pageCount, EmbedCreateSpec content) {
            return PageData.of(args, index, pageCount, content, Collections.emptyList());
        }
    }
}

