/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.bot_utils;

import discord4j.common.ReactorResources;
import io.netty.resolver.dns.DnsNameResolverTimeoutException;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.util.retry.Retry;

public final class HttpClientUtils {
    public static final Retry DEFAULT_DNS_RETRY_POLICY = Retry.backoff((long)5L, (Duration)Duration.ofSeconds(1L)).maxBackoff(Duration.ofSeconds(10L)).filter(ex -> ex instanceof DnsNameResolverTimeoutException).onRetryExhaustedThrow((retryBackoffSpec, retrySignal) -> retrySignal.failure());
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUtils.class);

    private HttpClientUtils() {
    }

    private static Throwable extractDnsTimeout(UnknownHostException exception) {
        return exception.getCause() instanceof DnsNameResolverTimeoutException ? exception.getCause() : exception;
    }

    public static Function<Mono<? extends Connection>, Mono<? extends Connection>> addDnsRetry(Retry retryPolicy) {
        return src -> src.onErrorMap(UnknownHostException.class, HttpClientUtils::extractDnsTimeout).doOnError(DnsNameResolverTimeoutException.class, ex -> LOGGER.warn("DNS query {} timed out", (Object)ex.question())).retryWhen(DEFAULT_DNS_RETRY_POLICY).doOnError(DnsNameResolverTimeoutException.class, ex -> LOGGER.error("DNS query {} reached the retry limit", (Object)ex.question())).doOnSubscribe(s -> LOGGER.trace("Hooking on connection"));
    }

    public static Function<Mono<? extends Connection>, Mono<? extends Connection>> addDnsRetry() {
        return HttpClientUtils.addDnsRetry(DEFAULT_DNS_RETRY_POLICY);
    }

    public static HttpClient addDnsRetry(HttpClient client, Retry retryPolicy) {
        return client.mapConnect(HttpClientUtils.addDnsRetry(retryPolicy));
    }

    public static HttpClient addDnsRetry(HttpClient client) {
        return HttpClientUtils.addDnsRetry(client, DEFAULT_DNS_RETRY_POLICY);
    }

    public static HttpClient enableMetrics(HttpClient client, EndpointType type) {
        return client.metrics(true, type.uriTagFormatter());
    }

    public static enum EndpointType {
        REST(() -> {
            Pattern idPattern = Pattern.compile("(?<=/)\\d++(?=/|$)");
            return s -> idPattern.matcher((CharSequence)s).replaceAll("{id}");
        }),
        ATTACHMENT(() -> p -> p.startsWith("/attachments/") ? "/attachments/{message}/{id}/{file}" : p);

        final UnaryOperator<String> uriTagFormatter;

        private EndpointType(Supplier<UnaryOperator<String>> uriTagFormatter) {
            this.uriTagFormatter = uriTagFormatter.get();
        }

        public UnaryOperator<String> uriTagFormatter() {
            return this.uriTagFormatter;
        }

        public HttpClient configureClient(HttpClient client, Retry dnsRetryPolicy) {
            client = HttpClientUtils.addDnsRetry(client, dnsRetryPolicy);
            client = HttpClientUtils.enableMetrics(client, this);
            return client;
        }

        public HttpClient configureClient(HttpClient client) {
            return this.configureClient(client, DEFAULT_DNS_RETRY_POLICY);
        }

        public HttpClient configureClient(Retry dnsRetryPolicy) {
            return this.configureClient((HttpClient)ReactorResources.DEFAULT_HTTP_CLIENT.get(), dnsRetryPolicy);
        }

        public HttpClient configureClient() {
            return this.configureClient(DEFAULT_DNS_RETRY_POLICY);
        }
    }
}

