/*
 * Decompiled with CFR 0.152.
 */
package dev.sympho.bot_utils;

import discord4j.common.util.Snowflake;
import discord4j.core.object.Embed;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateFields;
import discord4j.discordjson.possible.Possible;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class DiscordUtils {
    private DiscordUtils() {
    }

    @SideEffectFree
    public static <T> Possible<T> toPossible(Optional<T> o) {
        if (o.isPresent()) {
            return Possible.of(o.get());
        }
        return Possible.absent();
    }

    @SideEffectFree
    public static EmbedCreateSpec toSpec(Embed embed) {
        EmbedCreateSpec.Builder builder = EmbedCreateSpec.builder().title(DiscordUtils.toPossible(embed.getTitle())).description(DiscordUtils.toPossible(embed.getDescription())).thumbnail(DiscordUtils.toPossible(embed.getThumbnail().map(Embed.Thumbnail::getUrl))).image(DiscordUtils.toPossible(embed.getImage().map(Embed.Image::getUrl))).color(DiscordUtils.toPossible(embed.getColor()));
        if (embed.getAuthor().isPresent()) {
            Embed.Author author = (Embed.Author)embed.getAuthor().get();
            builder.author(author.getName().orElse(""), (String)author.getUrl().orElse(null), (String)author.getIconUrl().orElse(null));
        }
        if (embed.getFooter().isPresent()) {
            Embed.Footer footer = (Embed.Footer)embed.getFooter().get();
            builder.footer(footer.getText(), (String)footer.getIconUrl().orElse(null));
        }
        for (Embed.Field field : embed.getFields()) {
            builder.addField(field.getName(), field.getValue(), field.isInline());
        }
        return builder.build();
    }

    @SideEffectFree
    private static String mention(String prefix, Snowflake id) {
        return String.join((CharSequence)"", "<", prefix, id.asString(), ">");
    }

    @SideEffectFree
    public static String mentionUser(Snowflake id) {
        return DiscordUtils.mention("@", id);
    }

    @SideEffectFree
    public static String mentionRole(Snowflake id) {
        return DiscordUtils.mention("@&", id);
    }

    @SideEffectFree
    public static String mentionChannel(Snowflake id) {
        return DiscordUtils.mention("#", id);
    }

    @SideEffectFree
    public static MessageCreateFields.File attachData(String filename, byte[] data, boolean spoiler) throws AttachmentException {
        try {
            AutoCloseInputStream stream = ((AutoCloseInputStream.Builder)AutoCloseInputStream.builder().setByteArray(data)).get();
            return spoiler ? MessageCreateFields.FileSpoiler.of((String)filename, (InputStream)stream) : MessageCreateFields.File.of((String)filename, (InputStream)stream);
        }
        catch (IOException ex) {
            throw new AttachmentException("Could not attach file data", ex);
        }
    }

    @SideEffectFree
    public static MessageCreateFields.File attachImage(String name, BufferedImage image, boolean spoiler) throws AttachmentException {
        MessageCreateFields.File file;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", os);
            file = DiscordUtils.attachData(name + ".png", os.toByteArray(), spoiler);
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new AttachmentException("Could not write image", ex);
            }
        }
        os.close();
        return file;
    }

    public static class AttachmentException
    extends RuntimeException {
        private static final long serialVersionUID = -1570577395324066698L;

        public AttachmentException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

