/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.substrate.scale;

import dev.sublab.common.FromByteArray;
import dev.sublab.substrate.scale.DynamicType;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@DynamicType(lookupIndex=6)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u0006H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Ldev/sublab/substrate/scale/Balance;", "Ldev/sublab/common/FromByteArray;", "value", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "byteArray", "", "([B)V", "getValue", "()Ljava/math/BigInteger;", "toByteArray", "substrate-client-kotlin"})
public final class Balance
extends FromByteArray {
    @NotNull
    private final BigInteger value;

    public Balance(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        super(byteArray);
        this.value = new BigInteger(ArraysKt.reversedArray((byte[])byteArray));
    }

    public Balance(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] byArray = value.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.toByteArray()");
        this(ArraysKt.reversedArray((byte[])byArray));
    }

    @NotNull
    public final BigInteger getValue() {
        return this.value;
    }

    @NotNull
    public byte[] toByteArray() {
        byte[] byArray = this.value.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"value.toByteArray()");
        return ArraysKt.reversedArray((byte[])byArray);
    }
}

