/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.substrate.modules.system;

import dev.sublab.common.ByteArrayConvertible;
import dev.sublab.common.ByteArrayConvertibleKt;
import dev.sublab.encrypting.keys.KeyPair;
import dev.sublab.hex.StringKt;
import dev.sublab.ss58.ByteArrayKt;
import dev.sublab.substrate.SubstrateConstants;
import dev.sublab.substrate.SubstrateStorage;
import dev.sublab.substrate.modules.system.SystemModule;
import dev.sublab.substrate.modules.system.constants.RuntimeVersion;
import dev.sublab.substrate.modules.system.storage.Account;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\u0010\t\u001a\u00060\fj\u0002`\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u001b\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u001b\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0018\u001a\u00020\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011J\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Ldev/sublab/substrate/modules/system/SystemModuleClient;", "Ldev/sublab/substrate/modules/system/SystemModule;", "constants", "Ldev/sublab/substrate/SubstrateConstants;", "storage", "Ldev/sublab/substrate/SubstrateStorage;", "(Ldev/sublab/substrate/SubstrateConstants;Ldev/sublab/substrate/SubstrateStorage;)V", "accountByAccountId", "Ldev/sublab/substrate/modules/system/storage/Account;", "accountId", "Ldev/sublab/common/ByteArrayConvertible;", "(Ldev/sublab/common/ByteArrayConvertible;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "Ldev/sublab/ss58/AccountId;", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "accountIdHex", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "accountByKeyPair", "keyPair", "Ldev/sublab/encrypting/keys/KeyPair;", "(Ldev/sublab/encrypting/keys/KeyPair;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "accountByPublicKey", "publicKey", "publicKeyHex", "runtimeVersion", "Ldev/sublab/substrate/modules/system/constants/RuntimeVersion;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "substrate-client-kotlin"})
public final class SystemModuleClient
implements SystemModule {
    @NotNull
    private final SubstrateConstants constants;
    @NotNull
    private final SubstrateStorage storage;

    public SystemModuleClient(@NotNull SubstrateConstants constants, @NotNull SubstrateStorage storage) {
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.constants = constants;
        this.storage = storage;
    }

    @Override
    @Nullable
    public Object runtimeVersion(@NotNull Continuation<? super RuntimeVersion> $completion) {
        return FlowKt.first(this.constants.fetch("system", "version", Reflection.getOrCreateKotlinClass(RuntimeVersion.class)), $completion);
    }

    @Override
    @Nullable
    public Object accountByAccountId(@NotNull ByteArrayConvertible accountId, @NotNull Continuation<? super Account> $completion) {
        return FlowKt.first(this.storage.fetch("system", "account", accountId, Reflection.getOrCreateKotlinClass(Account.class)), $completion);
    }

    @Override
    @Nullable
    public Object accountByAccountId(@NotNull byte[] accountId, @NotNull Continuation<? super Account> $completion) {
        return this.accountByAccountId(ByteArrayConvertibleKt.asByteArrayConvertible((byte[])accountId), $completion);
    }

    @Override
    @Nullable
    public Object accountByAccountId(@NotNull String accountIdHex, @NotNull Continuation<? super Account> $completion) {
        return this.accountByAccountId(StringKt.getHex((String)accountIdHex).decode(), $completion);
    }

    @Override
    @Nullable
    public Object accountByPublicKey(@NotNull byte[] publicKey, @NotNull Continuation<? super Account> $completion) {
        return this.accountByAccountId(ByteArrayKt.getSs58((byte[])publicKey).accountId(), $completion);
    }

    @Override
    @Nullable
    public Object accountByPublicKey(@NotNull String publicKeyHex, @NotNull Continuation<? super Account> $completion) {
        return this.accountByPublicKey(StringKt.getHex((String)publicKeyHex).decode(), $completion);
    }

    @Override
    @Nullable
    public Object accountByKeyPair(@NotNull KeyPair keyPair, @NotNull Continuation<? super Account> $completion) {
        return this.accountByPublicKey(keyPair.getPublicKey(), $completion);
    }
}

