/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.substrate.modules;

import dev.sublab.substrate.ScaleCodecProvider;
import dev.sublab.substrate.SubstrateClient;
import dev.sublab.substrate.hashers.HashersProvider;
import dev.sublab.substrate.modules.InternalModuleProvider;
import dev.sublab.substrate.modules.chain.ChainModule;
import dev.sublab.substrate.modules.chain.ChainModuleClient;
import dev.sublab.substrate.modules.payment.PaymentModule;
import dev.sublab.substrate.modules.payment.PaymentModuleClient;
import dev.sublab.substrate.modules.state.StateModule;
import dev.sublab.substrate.modules.state.StateModuleClient;
import dev.sublab.substrate.modules.system.SystemModule;
import dev.sublab.substrate.modules.system.SystemModuleClient;
import dev.sublab.substrate.rpcClient.Rpc;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Ldev/sublab/substrate/modules/DefaultModuleProvider;", "Ldev/sublab/substrate/modules/InternalModuleProvider;", "codecProvider", "Ldev/sublab/substrate/ScaleCodecProvider;", "rpc", "Ldev/sublab/substrate/rpcClient/Rpc;", "hashersProvider", "Ldev/sublab/substrate/hashers/HashersProvider;", "(Ldev/sublab/substrate/ScaleCodecProvider;Ldev/sublab/substrate/rpcClient/Rpc;Ldev/sublab/substrate/hashers/HashersProvider;)V", "chain", "Ldev/sublab/substrate/modules/chain/ChainModule;", "getChain", "()Ldev/sublab/substrate/modules/chain/ChainModule;", "client", "Ldev/sublab/substrate/SubstrateClient;", "getClient", "()Ldev/sublab/substrate/SubstrateClient;", "setClient", "(Ldev/sublab/substrate/SubstrateClient;)V", "payment", "Ldev/sublab/substrate/modules/payment/PaymentModule;", "getPayment", "()Ldev/sublab/substrate/modules/payment/PaymentModule;", "state", "Ldev/sublab/substrate/modules/state/StateModule;", "getState", "()Ldev/sublab/substrate/modules/state/StateModule;", "system", "Ldev/sublab/substrate/modules/system/SystemModule;", "getSystem", "()Ldev/sublab/substrate/modules/system/SystemModule;", "workingWithClient", "", "substrate-client-kotlin"})
public final class DefaultModuleProvider
implements InternalModuleProvider {
    @NotNull
    private final ScaleCodecProvider codecProvider;
    @NotNull
    private final Rpc rpc;
    @NotNull
    private final HashersProvider hashersProvider;
    public SubstrateClient client;

    public DefaultModuleProvider(@NotNull ScaleCodecProvider codecProvider, @NotNull Rpc rpc, @NotNull HashersProvider hashersProvider) {
        Intrinsics.checkNotNullParameter((Object)codecProvider, (String)"codecProvider");
        Intrinsics.checkNotNullParameter((Object)rpc, (String)"rpc");
        Intrinsics.checkNotNullParameter((Object)hashersProvider, (String)"hashersProvider");
        this.codecProvider = codecProvider;
        this.rpc = rpc;
        this.hashersProvider = hashersProvider;
    }

    @NotNull
    public final SubstrateClient getClient() {
        SubstrateClient substrateClient = this.client;
        if (substrateClient != null) {
            return substrateClient;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
        return null;
    }

    public final void setClient(@NotNull SubstrateClient substrateClient) {
        Intrinsics.checkNotNullParameter((Object)substrateClient, (String)"<set-?>");
        this.client = substrateClient;
    }

    @Override
    @NotNull
    public ChainModule getChain() {
        return new ChainModuleClient(this.rpc);
    }

    @Override
    @NotNull
    public StateModule getState() {
        return new StateModuleClient(this.codecProvider.getHex(), this.rpc, this.hashersProvider);
    }

    @Override
    @NotNull
    public SystemModule getSystem() {
        return new SystemModuleClient(this.getClient().getConstants(), this.getClient().getStorage());
    }

    @Override
    @NotNull
    public PaymentModule getPayment() {
        return new PaymentModuleClient(this.codecProvider.getHex(), this.rpc);
    }

    @Override
    public void workingWithClient(@NotNull SubstrateClient client2) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        this.setClient(client2);
    }
}

