/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.substrate.hashers;

import dev.sublab.common.ByteArrayConvertible;
import dev.sublab.hashing.Hashing;
import dev.sublab.hashing.HashingKt;
import dev.sublab.hashing.hashers.Blake2bKt;
import dev.sublab.hashing.hashers.XXKt;
import dev.sublab.substrate.hashers.StorageHashing;
import dev.sublab.substrate.metadata.modules.storage.RuntimeModuleStorage;
import dev.sublab.substrate.metadata.modules.storage.RuntimeModuleStorageHasher;
import dev.sublab.substrate.metadata.modules.storage.item.RuntimeModuleStorageItem;
import dev.sublab.substrate.metadata.modules.storage.item.type.RuntimeModuleStorageItemType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0002J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ldev/sublab/substrate/hashers/StorageHasher;", "Ldev/sublab/substrate/hashers/StorageHashing;", "storage", "Ldev/sublab/substrate/metadata/modules/storage/RuntimeModuleStorage;", "(Ldev/sublab/substrate/metadata/modules/storage/RuntimeModuleStorage;)V", "hash", "", "storageItem", "Ldev/sublab/substrate/metadata/modules/storage/item/RuntimeModuleStorageItem;", "keys", "", "Ldev/sublab/common/ByteArrayConvertible;", "key", "hasher", "Ldev/sublab/substrate/metadata/modules/storage/RuntimeModuleStorageHasher;", "hashMapKey", "hashers", "hashPlainKey", "substrate-client-kotlin"})
public final class StorageHasher
implements StorageHashing {
    @NotNull
    private final RuntimeModuleStorage storage;

    public StorageHasher(@NotNull RuntimeModuleStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
    }

    private final byte[] hashPlainKey(RuntimeModuleStorageItem storageItem) {
        return ArraysKt.plus((byte[])XXKt.xx128((Hashing)HashingKt.getHashing((String)this.storage.getPrefix())), (byte[])XXKt.xx128((Hashing)HashingKt.getHashing((String)storageItem.getName())));
    }

    private final byte[] hash(byte[] key, RuntimeModuleStorageHasher hasher) {
        byte[] byArray;
        switch (WhenMappings.$EnumSwitchMapping$0[hasher.ordinal()]) {
            case 1: {
                byArray = Blake2bKt.blake2b_128((Hashing)HashingKt.getHashing((byte[])key));
                break;
            }
            case 2: {
                byArray = Blake2bKt.blake2b_256((Hashing)HashingKt.getHashing((byte[])key));
                break;
            }
            case 3: {
                byArray = ArraysKt.plus((byte[])Blake2bKt.blake2b_128((Hashing)HashingKt.getHashing((byte[])key)), (byte[])key);
                break;
            }
            case 4: {
                byArray = XXKt.xx128((Hashing)HashingKt.getHashing((byte[])key));
                break;
            }
            case 5: {
                byArray = XXKt.xx256((Hashing)HashingKt.getHashing((byte[])key));
                break;
            }
            case 6: {
                byArray = ArraysKt.plus((byte[])XXKt.xx64((Hashing)HashingKt.getHashing((byte[])key)), (byte[])key);
                break;
            }
            case 7: {
                byArray = key;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private final byte[] hashMapKey(RuntimeModuleStorageItem storageItem, List<? extends ByteArrayConvertible> keys, List<? extends RuntimeModuleStorageHasher> hashers) {
        void $this$fold$iv;
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv;
        Iterable iterable = hashers;
        boolean $i$f$mapIndexed = false;
        void var6_7 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void hasher;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            RuntimeModuleStorageHasher runtimeModuleStorageHasher = (RuntimeModuleStorageHasher)((Object)item$iv$iv);
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.hash(keys.get((int)index).toByteArray(), (RuntimeModuleStorageHasher)hasher));
        }
        $this$mapIndexed$iv = (List)destination$iv$iv;
        byte[] initial$iv = this.hashPlainKey(storageItem);
        boolean $i$f$fold = false;
        byte[] accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void hash;
            Object object = (byte[])element$iv;
            byte[] result = accumulator$iv;
            boolean bl = false;
            accumulator$iv = ArraysKt.plus((byte[])result, (byte[])hash);
        }
        return accumulator$iv;
    }

    @Override
    @NotNull
    public byte[] hash(@NotNull RuntimeModuleStorageItem storageItem, @NotNull List<? extends ByteArrayConvertible> keys) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)storageItem, (String)"storageItem");
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        RuntimeModuleStorageItemType runtimeModuleStorageItemType = storageItem.getType();
        if (runtimeModuleStorageItemType instanceof RuntimeModuleStorageItemType.Plain) {
            byArray = this.hashPlainKey(storageItem);
        } else if (runtimeModuleStorageItemType instanceof RuntimeModuleStorageItemType.Map) {
            if (!(keys.size() == ((RuntimeModuleStorageItemType.Map)storageItem.getType()).getValue().getHashers().size())) {
                boolean bl = false;
                String string = "Keys count should be equal to hashers count";
                throw new IllegalStateException(string.toString());
            }
            byArray = this.hashMapKey(storageItem, keys, ((RuntimeModuleStorageItemType.Map)storageItem.getType()).getValue().getHashers());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return byArray;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RuntimeModuleStorageHasher.values().length];
            try {
                nArray[RuntimeModuleStorageHasher.Blake128.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeModuleStorageHasher.Blake256.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeModuleStorageHasher.Blake128Concat.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeModuleStorageHasher.Twox128.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeModuleStorageHasher.Twox256.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeModuleStorageHasher.Twox64Concat.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RuntimeModuleStorageHasher.Identity.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

