/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.substrate;

import dev.sublab.substrate.FindStorageItemResult;
import dev.sublab.substrate.ModulePath;
import dev.sublab.substrate.SubstrateClientNamingPolicy;
import dev.sublab.substrate.metadata.RuntimeMetadata;
import dev.sublab.substrate.metadata.lookup.RuntimeType;
import dev.sublab.substrate.metadata.modules.RuntimeModule;
import dev.sublab.substrate.metadata.modules.RuntimeModuleConstant;
import dev.sublab.substrate.metadata.modules.storage.RuntimeModuleStorage;
import dev.sublab.substrate.metadata.modules.storage.item.RuntimeModuleStorageItem;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\fJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ldev/sublab/substrate/SubstrateLookupServiceImplementation;", "", "runtimeMetadata", "Ldev/sublab/substrate/metadata/RuntimeMetadata;", "namingPolicy", "Ldev/sublab/substrate/SubstrateClientNamingPolicy;", "(Ldev/sublab/substrate/metadata/RuntimeMetadata;Ldev/sublab/substrate/SubstrateClientNamingPolicy;)V", "constantsCache", "", "Ldev/sublab/substrate/ModulePath;", "Ldev/sublab/substrate/metadata/modules/RuntimeModuleConstant;", "modulesCache", "", "Ldev/sublab/substrate/metadata/modules/RuntimeModule;", "storageItemsCache", "Ldev/sublab/substrate/metadata/modules/storage/item/RuntimeModuleStorageItem;", "findConstant", "module", "name", "moduleName", "constantName", "findModule", "findRuntimeType", "Ldev/sublab/substrate/metadata/lookup/RuntimeType;", "index", "Ljava/math/BigInteger;", "findStorageItem", "Ldev/sublab/substrate/FindStorageItemResult;", "itemName", "substrate-client-kotlin"})
final class SubstrateLookupServiceImplementation {
    @NotNull
    private final RuntimeMetadata runtimeMetadata;
    @NotNull
    private final SubstrateClientNamingPolicy namingPolicy;
    @NotNull
    private final Map<String, RuntimeModule> modulesCache;
    @NotNull
    private final Map<ModulePath, RuntimeModuleConstant> constantsCache;
    @NotNull
    private final Map<ModulePath, RuntimeModuleStorageItem> storageItemsCache;

    public SubstrateLookupServiceImplementation(@NotNull RuntimeMetadata runtimeMetadata, @NotNull SubstrateClientNamingPolicy namingPolicy) {
        Intrinsics.checkNotNullParameter((Object)runtimeMetadata, (String)"runtimeMetadata");
        Intrinsics.checkNotNullParameter((Object)((Object)namingPolicy), (String)"namingPolicy");
        this.runtimeMetadata = runtimeMetadata;
        this.namingPolicy = namingPolicy;
        this.modulesCache = new LinkedHashMap();
        this.constantsCache = new LinkedHashMap();
        this.storageItemsCache = new LinkedHashMap();
    }

    @Nullable
    public final RuntimeModule findModule(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RuntimeModule runtimeModule = this.modulesCache.get(name);
        if (runtimeModule == null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = this.runtimeMetadata.getModules();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RuntimeModule it = (RuntimeModule)element$iv;
                    boolean bl = false;
                    if (!this.namingPolicy.equals$substrate_client_kotlin(it.getName(), name)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            if ((runtimeModule = (RuntimeModule)v1) == null) {
                return null;
            }
        }
        RuntimeModule module = runtimeModule;
        this.modulesCache.put(name, module);
        return module;
    }

    private final RuntimeModuleConstant findConstant(RuntimeModule module, String name) {
        ModulePath constantPath = new ModulePath(module.getName(), name);
        RuntimeModuleConstant runtimeModuleConstant = this.constantsCache.get(constantPath);
        if (runtimeModuleConstant == null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = module.getConstants();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RuntimeModuleConstant it = (RuntimeModuleConstant)element$iv;
                    boolean bl = false;
                    if (!this.namingPolicy.equals$substrate_client_kotlin(it.getName(), name)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            if ((runtimeModuleConstant = (RuntimeModuleConstant)v1) == null) {
                return null;
            }
        }
        RuntimeModuleConstant constant = runtimeModuleConstant;
        this.constantsCache.put(constantPath, constant);
        return constant;
    }

    @Nullable
    public final RuntimeModuleConstant findConstant(@NotNull String moduleName, @NotNull String constantName) {
        RuntimeModuleConstant runtimeModuleConstant;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)constantName, (String)"constantName");
        RuntimeModule runtimeModule = this.findModule(moduleName);
        if (runtimeModule != null) {
            RuntimeModule it = runtimeModule;
            boolean bl = false;
            runtimeModuleConstant = this.findConstant(it, constantName);
        } else {
            runtimeModuleConstant = null;
        }
        return runtimeModuleConstant;
    }

    private final FindStorageItemResult findStorageItem(RuntimeModule module, String name) {
        RuntimeModuleStorage runtimeModuleStorage = module.getStorage();
        if (runtimeModuleStorage == null) {
            return null;
        }
        RuntimeModuleStorage storage = runtimeModuleStorage;
        ModulePath constantPath = new ModulePath(module.getName(), name);
        RuntimeModuleStorageItem runtimeModuleStorageItem = this.storageItemsCache.get(constantPath);
        if (runtimeModuleStorageItem == null) {
            Object v2;
            block4: {
                Iterable $this$firstOrNull$iv = module.getStorage().getItems();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RuntimeModuleStorageItem it = (RuntimeModuleStorageItem)element$iv;
                    boolean bl = false;
                    if (!this.namingPolicy.equals$substrate_client_kotlin(it.getName(), name)) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            if ((runtimeModuleStorageItem = (RuntimeModuleStorageItem)v2) == null) {
                return null;
            }
        }
        RuntimeModuleStorageItem item = runtimeModuleStorageItem;
        this.storageItemsCache.put(constantPath, item);
        return new FindStorageItemResult(item, storage);
    }

    @Nullable
    public final FindStorageItemResult findStorageItem(@NotNull String moduleName, @NotNull String itemName) {
        FindStorageItemResult findStorageItemResult;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)itemName, (String)"itemName");
        RuntimeModule runtimeModule = this.findModule(moduleName);
        if (runtimeModule != null) {
            RuntimeModule it = runtimeModule;
            boolean bl = false;
            findStorageItemResult = this.findStorageItem(it, itemName);
        } else {
            findStorageItemResult = null;
        }
        return findStorageItemResult;
    }

    @Nullable
    public final RuntimeType findRuntimeType(@NotNull BigInteger index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        return this.runtimeMetadata.getLookup().findItemByIndex(index);
    }
}

