/**
 *
 * Copyright 2023 SUBSTRATE LABORATORY LLC <info@sublab.dev>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0

 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

package dev.sublab.substrate.utils

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Job
import kotlinx.coroutines.launch
import kotlinx.datetime.Clock
import kotlinx.datetime.Instant

class JobWithTimeout(
    private val scope: CoroutineScope = CoroutineScope(Job()),
    private val timeoutMs: Long,
    private val job: suspend () -> Unit
) {

    private var lastPerform: Instant? = null

    fun perform() {
        val current = Clock.System.now()
        val canPerform = lastPerform?.let {
            (current - it).inWholeMilliseconds > timeoutMs
        } ?: true

        if (canPerform) {
            lastPerform = current
            scope.launch {
                job()
            }
        }
    }
}