/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.scale.adapters;

import dev.sublab.common.numerics.UInt16Kt;
import dev.sublab.common.numerics.UInt32Kt;
import dev.sublab.scale.ByteArrayReader;
import dev.sublab.scale.ScaleCodecAdapter;
import dev.sublab.scale.ScaleCodecAdapterKt;
import dev.sublab.scale.ScaleCodecAdapterProvider;
import dev.sublab.scale.adapters.BigIntegerAdapterKt;
import dev.sublab.scale.adapters.BigIntegerValueTooBig;
import dev.sublab.scale.adapters.NegativeBigIntegerNotSupported;
import java.lang.annotation.Annotation;
import java.math.BigInteger;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.UShort;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u001b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J&\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldev/sublab/scale/adapters/BigIntegerAdapter;", "Ldev/sublab/scale/ScaleCodecAdapter;", "Ljava/math/BigInteger;", "adapterResolver", "Ldev/sublab/scale/ScaleCodecAdapterProvider;", "(Ldev/sublab/scale/ScaleCodecAdapterProvider;)V", "read", "reader", "Ldev/sublab/scale/ByteArrayReader;", "type", "Lkotlin/reflect/KType;", "annotations", "", "", "write", "", "obj", "scale-codec-kotlin"})
public final class BigIntegerAdapter
extends ScaleCodecAdapter<BigInteger> {
    @NotNull
    private final ScaleCodecAdapterProvider adapterResolver;

    public BigIntegerAdapter(@NotNull ScaleCodecAdapterProvider adapterResolver) {
        Intrinsics.checkNotNullParameter((Object)adapterResolver, (String)"adapterResolver");
        this.adapterResolver = adapterResolver;
    }

    @Override
    @NotNull
    public BigInteger read(@NotNull ByteArrayReader reader, @NotNull KType type, @NotNull List<? extends Annotation> annotations) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        byte by = reader.readByte();
        byte mode = (byte)(by & 3);
        byte value = (byte)(by | 3);
        switch (mode) {
            case 0: {
                object = UInt.box-impl((int)UInt.constructor-impl((int)(UInt.constructor-impl((int)(UByte.constructor-impl((byte)value) & 0xFF)) >>> 2)));
                break;
            }
            case 1: {
                object = UInt.box-impl((int)UInt.constructor-impl((int)(UInt.constructor-impl((int)(UInt16Kt.toUShort((byte[])BigIntegerAdapter.read$readByteArray(value, reader, 2)) & 0xFFFF)) >>> 2)));
                break;
            }
            case 2: {
                object = UInt.box-impl((int)UInt.constructor-impl((int)(UInt32Kt.toUInt((byte[])BigIntegerAdapter.read$readByteArray(value, reader, 4)) >>> 2)));
                break;
            }
            default: {
                object = BigIntegerAdapterKt.clampedToBigInteger(reader.read((value >> 2) + 4));
            }
        }
        return new BigInteger(object.toString());
    }

    @Override
    @NotNull
    public byte[] write(@NotNull BigInteger obj, @NotNull KType type, @NotNull List<? extends Annotation> annotations) throws NegativeBigIntegerNotSupported {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        if (obj.signum() < 0) {
            throw new NegativeBigIntegerNotSupported();
        }
        if (obj.compareTo(BigIntegerAdapterKt.getMAX_BIG_INTEGER_SCALE_VALUE()) > 0) {
            throw new BigIntegerValueTooBig();
        }
        byte mode = BigIntegerAdapterKt.access$detectMode(obj);
        switch (mode) {
            case 0: {
                byArray = ScaleCodecAdapterKt.write(this.adapterResolver.findAdapter(Reflection.getOrCreateKotlinClass(UByte.class)), UByte.box-impl((byte)UByte.constructor-impl((byte)((byte)UInt.constructor-impl((int)(UInt.constructor-impl((int)obj.intValue()) << 2))))), Reflection.getOrCreateKotlinClass(UByte.class));
                break;
            }
            case 1: {
                byArray = ScaleCodecAdapterKt.write(this.adapterResolver.findAdapter(Reflection.getOrCreateKotlinClass(UShort.class)), UShort.box-impl((short)UShort.constructor-impl((short)((short)UInt.constructor-impl((int)(UInt.constructor-impl((int)(UInt.constructor-impl((int)obj.intValue()) << 2)) | UInt.constructor-impl((int)mode)))))), Reflection.getOrCreateKotlinClass(UShort.class));
                break;
            }
            case 2: {
                byArray = ScaleCodecAdapterKt.write(this.adapterResolver.findAdapter(Reflection.getOrCreateKotlinClass(UInt.class)), UInt.box-impl((int)UInt.constructor-impl((int)(UInt.constructor-impl((int)(UInt.constructor-impl((int)obj.intValue()) << 2)) | UInt.constructor-impl((int)mode)))), Reflection.getOrCreateKotlinClass(UInt.class));
                break;
            }
            default: {
                byte[] result = BigIntegerAdapterKt.toClampedByteArray(obj);
                int count = result.length - 4 << 2 | 3;
                byte[] prefix = ScaleCodecAdapterKt.write(this.adapterResolver.findAdapter(Reflection.getOrCreateKotlinClass(UByte.class)), UByte.box-impl((byte)UByte.constructor-impl((byte)((byte)count))), Reflection.getOrCreateKotlinClass(UByte.class));
                return ArraysKt.plus((byte[])prefix, (byte[])result);
            }
        }
        return byArray;
    }

    private static final byte[] read$readByteArray(byte value, ByteArrayReader $reader, int typeBytes) {
        byte[] byArray = new byte[]{value};
        return ArraysKt.plus((byte[])byArray, (byte[])$reader.read(typeBytes - 1));
    }
}

