/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.curve25519.unpackedScalar;

import dev.sublab.curve25519.scalar.Scalar;
import dev.sublab.curve25519.unpackedScalar.UnpackedScalarKt;
import dev.sublab.curve25519.unpackedScalar.functions.ByteArrayKt;
import dev.sublab.curve25519.unpackedScalar.functions.MontgomeryReduceKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0010\u0016\n\u0002\b\u0006\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\fJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ldev/sublab/curve25519/unpackedScalar/UnpackedScalar;", "", "s", "", "([I)V", "getS$curve25519_kotlin", "()[I", "add", "b", "mulInternal", "", "value", "mulInternal$curve25519_kotlin", "multiply", "subtract", "Companion", "curve25519-kotlin"})
public final class UnpackedScalar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] s;
    @NotNull
    private static final Scalar BASEPOINT_ORDER;
    @NotNull
    private static final UnpackedScalar L;
    private static final int LFACTOR;
    @NotNull
    private static final UnpackedScalar R;
    @NotNull
    private static final UnpackedScalar RR;

    public UnpackedScalar(@NotNull int[] s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.s = s;
        if (this.s.length != 9) {
            throw new IllegalArgumentException("Invalid radix-2^29 representation");
        }
    }

    @NotNull
    public final int[] getS$curve25519_kotlin() {
        return this.s;
    }

    @NotNull
    public final UnpackedScalar add(@NotNull UnpackedScalar b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int[] sum = new int[9];
        int carry = 0;
        for (int i = 0; i < 9; ++i) {
            carry = this.s[i] + b.s[i] + (carry >> 29);
            sum[i] = carry & 0x1FFFFFFF;
        }
        return new UnpackedScalar(sum).subtract(L);
    }

    @NotNull
    public final UnpackedScalar subtract(@NotNull UnpackedScalar b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int[] difference = new int[9];
        int borrow = 0;
        for (int i = 0; i < 9; ++i) {
            borrow = this.s[i] - (b.s[i] + (borrow >>> 31));
            difference[i] = borrow & 0x1FFFFFFF;
        }
        int underflowMask = (borrow >>> 31 ^ 1) - 1;
        int carry = 0;
        for (int i = 0; i < 9; ++i) {
            carry = (carry >>> 29) + difference[i] + (UnpackedScalar.L.s[i] & underflowMask);
            difference[i] = carry & 0x1FFFFFFF;
        }
        return new UnpackedScalar(difference);
    }

    @NotNull
    public final long[] mulInternal$curve25519_kotlin(@NotNull UnpackedScalar value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int[] a = this.s;
        int[] b = value.s;
        long[] z = new long[17];
        z[0] = UnpackedScalarKt.m(a[0], b[0]);
        z[1] = UnpackedScalarKt.m(a[0], b[1]) + UnpackedScalarKt.m(a[1], b[0]);
        z[2] = UnpackedScalarKt.m(a[0], b[2]) + UnpackedScalarKt.m(a[1], b[1]) + UnpackedScalarKt.m(a[2], b[0]);
        z[3] = UnpackedScalarKt.m(a[0], b[3]) + UnpackedScalarKt.m(a[1], b[2]) + UnpackedScalarKt.m(a[2], b[1]) + UnpackedScalarKt.m(a[3], b[0]);
        z[4] = UnpackedScalarKt.m(a[0], b[4]) + UnpackedScalarKt.m(a[1], b[3]) + UnpackedScalarKt.m(a[2], b[2]) + UnpackedScalarKt.m(a[3], b[1]) + UnpackedScalarKt.m(a[4], b[0]);
        z[5] = UnpackedScalarKt.m(a[1], b[4]) + UnpackedScalarKt.m(a[2], b[3]) + UnpackedScalarKt.m(a[3], b[2]) + UnpackedScalarKt.m(a[4], b[1]);
        z[6] = UnpackedScalarKt.m(a[2], b[4]) + UnpackedScalarKt.m(a[3], b[3]) + UnpackedScalarKt.m(a[4], b[2]);
        z[7] = UnpackedScalarKt.m(a[3], b[4]) + UnpackedScalarKt.m(a[4], b[3]);
        z[8] = UnpackedScalarKt.m(a[4], b[4]) - z[3];
        z[10] = z[5] - UnpackedScalarKt.m(a[5], b[5]);
        z[11] = z[6] - (UnpackedScalarKt.m(a[5], b[6]) + UnpackedScalarKt.m(a[6], b[5]));
        z[12] = z[7] - (UnpackedScalarKt.m(a[5], b[7]) + UnpackedScalarKt.m(a[6], b[6]) + UnpackedScalarKt.m(a[7], b[5]));
        z[13] = UnpackedScalarKt.m(a[5], b[8]) + UnpackedScalarKt.m(a[6], b[7]) + UnpackedScalarKt.m(a[7], b[6]) + UnpackedScalarKt.m(a[8], b[5]);
        z[14] = UnpackedScalarKt.m(a[6], b[8]) + UnpackedScalarKt.m(a[7], b[7]) + UnpackedScalarKt.m(a[8], b[6]);
        z[15] = UnpackedScalarKt.m(a[7], b[8]) + UnpackedScalarKt.m(a[8], b[7]);
        z[16] = UnpackedScalarKt.m(a[8], b[8]);
        z[5] = z[10] - z[0];
        z[6] = z[11] - z[1];
        z[7] = z[12] - z[2];
        z[8] = z[8] - z[13];
        z[9] = z[14] + z[4];
        z[10] = z[15] + z[10];
        z[11] = z[16] + z[11];
        int[] nArray = new int[]{a[0] + a[5], a[1] + a[6], a[2] + a[7], a[3] + a[8]};
        int[] aa = nArray;
        int[] nArray2 = new int[]{b[0] + b[5], b[1] + b[6], b[2] + b[7], b[3] + b[8]};
        int[] bb = nArray2;
        z[5] = UnpackedScalarKt.m(aa[0], bb[0]) + z[5];
        z[6] = UnpackedScalarKt.m(aa[0], bb[1]) + UnpackedScalarKt.m(aa[1], bb[0]) + z[6];
        z[7] = UnpackedScalarKt.m(aa[0], bb[2]) + UnpackedScalarKt.m(aa[1], bb[1]) + UnpackedScalarKt.m(aa[2], bb[0]) + z[7];
        z[8] = UnpackedScalarKt.m(aa[0], bb[3]) + UnpackedScalarKt.m(aa[1], bb[2]) + UnpackedScalarKt.m(aa[2], bb[1]) + UnpackedScalarKt.m(aa[3], bb[0]) + z[8];
        z[9] = UnpackedScalarKt.m(aa[0], b[4]) + UnpackedScalarKt.m(aa[1], bb[3]) + UnpackedScalarKt.m(aa[2], bb[2]) + UnpackedScalarKt.m(aa[3], bb[1]) + UnpackedScalarKt.m(a[4], bb[0]) - z[9];
        z[10] = UnpackedScalarKt.m(aa[1], b[4]) + UnpackedScalarKt.m(aa[2], bb[3]) + UnpackedScalarKt.m(aa[3], bb[2]) + UnpackedScalarKt.m(a[4], bb[1]) - z[10];
        z[11] = UnpackedScalarKt.m(aa[2], b[4]) + UnpackedScalarKt.m(aa[3], bb[3]) + UnpackedScalarKt.m(a[4], bb[2]) - z[11];
        z[12] = UnpackedScalarKt.m(aa[3], b[4]) + UnpackedScalarKt.m(a[4], bb[3]) - z[12];
        return z;
    }

    @NotNull
    public final UnpackedScalar multiply(@NotNull UnpackedScalar b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return MontgomeryReduceKt.montgomeryReduce(MontgomeryReduceKt.montgomeryReduce(this.mulInternal$curve25519_kotlin(b)).mulInternal$curve25519_kotlin(RR));
    }

    static {
        Object[] objectArray = new byte[]{-19, -45, -11, 92, 26, 99, 18, 88, -42, -100, -9, -94, -34, -7, -34, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16};
        BASEPOINT_ORDER = new Scalar((byte[])objectArray);
        L = ByteArrayKt.toUnpackedScalar(BASEPOINT_ORDER.toByteArray());
        LFACTOR = 307527195;
        objectArray = new int[9];
        objectArray[0] = 290322925;
        objectArray[1] = 442594051;
        objectArray[2] = 259787148;
        objectArray[3] = 377041255;
        objectArray[4] = 536700270;
        objectArray[5] = 0x1FFFFFFF;
        objectArray[6] = 0x1FFFFFFF;
        objectArray[7] = 0x1FFFFFFF;
        objectArray[8] = 1048575;
        R = new UnpackedScalar((int[])objectArray);
        objectArray = new int[9];
        objectArray[0] = 190815506;
        objectArray[1] = 504634135;
        objectArray[2] = 361594685;
        objectArray[3] = 339687255;
        objectArray[4] = 426956673;
        objectArray[5] = 70249340;
        objectArray[6] = 485410621;
        objectArray[7] = 504909086;
        objectArray[8] = 328813;
        RR = new UnpackedScalar((int[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u0013"}, d2={"Ldev/sublab/curve25519/unpackedScalar/UnpackedScalar$Companion;", "", "()V", "BASEPOINT_ORDER", "Ldev/sublab/curve25519/scalar/Scalar;", "getBASEPOINT_ORDER", "()Ldev/sublab/curve25519/scalar/Scalar;", "L", "Ldev/sublab/curve25519/unpackedScalar/UnpackedScalar;", "getL", "()Ldev/sublab/curve25519/unpackedScalar/UnpackedScalar;", "LFACTOR", "", "getLFACTOR", "()I", "R", "getR", "RR", "getRR", "curve25519-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Scalar getBASEPOINT_ORDER() {
            return BASEPOINT_ORDER;
        }

        @NotNull
        public final UnpackedScalar getL() {
            return L;
        }

        public final int getLFACTOR() {
            return LFACTOR;
        }

        @NotNull
        public final UnpackedScalar getR() {
            return R;
        }

        @NotNull
        public final UnpackedScalar getRR() {
            return RR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

