/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.curve25519.scalar;

import dev.sublab.curve25519.scalar.functions.MultiplyAndAddKt;
import dev.sublab.curve25519.scalar.functions.ReduceKt;
import dev.sublab.hex.ByteArrayHex;
import dev.sublab.hex.ByteArrayKt;
import dev.sublab.support.ConstantTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0000J\u0013\u0010\u000e\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0000J\u0006\u0010\u0014\u001a\u00020\u0003J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Ldev/sublab/curve25519/scalar/Scalar;", "", "s", "", "([B)V", "isCanonical", "", "()Z", "getS$curve25519_kotlin", "()[B", "add", "b", "ctEquals", "other", "equals", "hashCode", "", "multiply", "reduce", "subtract", "toByteArray", "toString", "", "Companion", "curve25519-kotlin"})
public final class Scalar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] s;
    @NotNull
    private static final Scalar ZERO;
    @NotNull
    private static final Scalar ONE;

    public Scalar(@NotNull byte[] s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        byte[] byArray = Arrays.copyOf(s, s.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
        this.s = byArray;
        if (!(s.length == 32 && (s[31] >> 7 & 1) == 0)) {
            boolean bl = false;
            String string = "Invalid scalar representation";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final byte[] getS$curve25519_kotlin() {
        return this.s;
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.s, this.s.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
        return byArray;
    }

    public final boolean ctEquals(@NotNull Scalar other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ConstantTime.INSTANCE.equal(this.s, other.s);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Scalar)) {
            return false;
        }
        return this.ctEquals((Scalar)other);
    }

    public int hashCode() {
        return Arrays.hashCode(this.s);
    }

    @NotNull
    public String toString() {
        return "Scalar(" + ByteArrayHex.encode$default((ByteArrayHex)ByteArrayKt.getHex((byte[])this.s), (boolean)false, (int)1, null) + ')';
    }

    public final boolean isCanonical() {
        return this.ctEquals(this.reduce());
    }

    @NotNull
    public final Scalar reduce() {
        return ReduceKt.reduceToScalar(this.s);
    }

    @NotNull
    public final Scalar add(@NotNull Scalar b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return new Scalar(dev.sublab.curve25519.unpackedScalar.functions.ByteArrayKt.toByteArray(dev.sublab.curve25519.unpackedScalar.functions.ByteArrayKt.toUnpackedScalar(this.s).add(dev.sublab.curve25519.unpackedScalar.functions.ByteArrayKt.toUnpackedScalar(b.s))));
    }

    @NotNull
    public final Scalar subtract(@NotNull Scalar b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return new Scalar(dev.sublab.curve25519.unpackedScalar.functions.ByteArrayKt.toByteArray(dev.sublab.curve25519.unpackedScalar.functions.ByteArrayKt.toUnpackedScalar(this.s).subtract(dev.sublab.curve25519.unpackedScalar.functions.ByteArrayKt.toUnpackedScalar(b.s))));
    }

    @NotNull
    public final Scalar multiply(@NotNull Scalar b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return MultiplyAndAddKt.multiplyAndAdd(this, b, ZERO);
    }

    static {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ZERO = new Scalar(byArray);
        byArray = new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ONE = new Scalar(byArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Ldev/sublab/curve25519/scalar/Scalar$Companion;", "", "()V", "ONE", "Ldev/sublab/curve25519/scalar/Scalar;", "getONE", "()Ldev/sublab/curve25519/scalar/Scalar;", "ZERO", "getZERO", "curve25519-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Scalar getZERO() {
            return ZERO;
        }

        @NotNull
        public final Scalar getONE() {
            return ONE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

