/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.curve25519.ristrettoElement;

import dev.sublab.curve25519.edwardsPoint.EdwardsPoint;
import dev.sublab.curve25519.fieldElement.FieldElement;
import dev.sublab.curve25519.fieldElement.SqrtRatioM1Kt;
import dev.sublab.curve25519.fieldElement.SqrtRatioM1Result;
import dev.sublab.curve25519.fieldElement.functions.ByteArrayKt;
import dev.sublab.curve25519.fieldElement.functions.MultiplyKt;
import dev.sublab.curve25519.fieldElement.functions.SquareKt;
import dev.sublab.curve25519.ristrettoElement.CompressedRistretto;
import dev.sublab.curve25519.ristrettoElement.RistrettoGeneratorTable;
import dev.sublab.curve25519.scalar.Scalar;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000J\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000J\u0016\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0000J\u0013\u0010\u0013\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Ldev/sublab/curve25519/ristrettoElement/RistrettoElement;", "", "representation", "Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;", "(Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;)V", "getRepresentation$curve25519_kotlin", "()Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;", "add", "q", "compress", "Ldev/sublab/curve25519/ristrettoElement/CompressedRistretto;", "ctEquals", "", "other", "ctSelect", "that", "b", "", "double", "equals", "hashCode", "multiply", "s", "Ldev/sublab/curve25519/scalar/Scalar;", "negate", "subtract", "toString", "", "Companion", "curve25519-kotlin"})
public final class RistrettoElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EdwardsPoint representation;
    @NotNull
    private static final RistrettoElement IDENTITY = new RistrettoElement(EdwardsPoint.Companion.getIDENTITY());
    @NotNull
    private static final RistrettoElement RISTRETTO_GENERATOR = new RistrettoElement(EdwardsPoint.Companion.getED25519_BASEPOINT());
    @NotNull
    private static final RistrettoGeneratorTable RISTRETTO_GENERATOR_TABLE = new RistrettoGeneratorTable(RISTRETTO_GENERATOR);

    public RistrettoElement(@NotNull EdwardsPoint representation) {
        Intrinsics.checkNotNullParameter((Object)representation, (String)"representation");
        this.representation = representation;
    }

    @NotNull
    public final EdwardsPoint getRepresentation$curve25519_kotlin() {
        return this.representation;
    }

    @NotNull
    public final CompressedRistretto compress() {
        FieldElement u1 = MultiplyKt.multiply(this.representation.getZ$curve25519_kotlin().add(this.representation.getY$curve25519_kotlin()), this.representation.getZ$curve25519_kotlin().subtract(this.representation.getY$curve25519_kotlin()));
        FieldElement u2 = MultiplyKt.multiply(this.representation.getX$curve25519_kotlin(), this.representation.getY$curve25519_kotlin());
        SqrtRatioM1Result invsqrt = SqrtRatioM1Kt.sqrtRatioM1(FieldElement.Companion.getONE(), MultiplyKt.multiply(u1, SquareKt.square$default(u2, 0, 1, null)));
        FieldElement den1 = MultiplyKt.multiply(invsqrt.getResult(), u1);
        FieldElement den2 = MultiplyKt.multiply(invsqrt.getResult(), u2);
        FieldElement zInv = MultiplyKt.multiply(MultiplyKt.multiply(den1, den2), this.representation.getT$curve25519_kotlin());
        FieldElement ix = MultiplyKt.multiply(this.representation.getX$curve25519_kotlin(), FieldElement.Companion.getSQRT_M1());
        FieldElement iy = MultiplyKt.multiply(this.representation.getY$curve25519_kotlin(), FieldElement.Companion.getSQRT_M1());
        FieldElement enchantedDenominator = MultiplyKt.multiply(den1, FieldElement.Companion.getINVSQRT_A_MINUS_D());
        boolean rotate = MultiplyKt.multiply(this.representation.getT$curve25519_kotlin(), zInv).isNegative();
        FieldElement x = this.representation.getX$curve25519_kotlin().ctSelect(iy, rotate);
        FieldElement y = this.representation.getY$curve25519_kotlin().ctSelect(ix, rotate);
        FieldElement z = this.representation.getZ$curve25519_kotlin();
        FieldElement denInv = den2.ctSelect(enchantedDenominator, rotate);
        y = y.ctSelect(y.negate(), MultiplyKt.multiply(x, zInv).isNegative());
        FieldElement s = MultiplyKt.multiply(denInv, z.subtract(y));
        s = s.ctSelect(s.negate(), s.isNegative());
        return new CompressedRistretto(ByteArrayKt.toByteArray(s));
    }

    public final boolean ctEquals(@NotNull RistrettoElement other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        FieldElement x1y2 = MultiplyKt.multiply(this.representation.getX$curve25519_kotlin(), other.representation.getY$curve25519_kotlin());
        FieldElement y1x2 = MultiplyKt.multiply(this.representation.getY$curve25519_kotlin(), other.representation.getX$curve25519_kotlin());
        FieldElement y1y2 = MultiplyKt.multiply(this.representation.getY$curve25519_kotlin(), other.representation.getY$curve25519_kotlin());
        FieldElement x1x2 = MultiplyKt.multiply(this.representation.getX$curve25519_kotlin(), other.representation.getX$curve25519_kotlin());
        return x1y2.ctEquals(y1x2) || y1y2.ctEquals(x1x2);
    }

    @NotNull
    public final RistrettoElement ctSelect(@NotNull RistrettoElement that, int b) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return new RistrettoElement(this.representation.ctSelect(that.representation, b));
    }

    @NotNull
    public final RistrettoElement ctSelect(@NotNull RistrettoElement that, boolean b) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return this.ctSelect(that, b ? 1 : 0);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof RistrettoElement)) {
            return false;
        }
        return this.ctEquals((RistrettoElement)other);
    }

    public int hashCode() {
        return this.compress().hashCode();
    }

    @NotNull
    public final RistrettoElement add(@NotNull RistrettoElement q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return new RistrettoElement(this.representation.add(q.representation));
    }

    @NotNull
    public final RistrettoElement subtract(@NotNull RistrettoElement q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return new RistrettoElement(this.representation.subtract(q.representation));
    }

    @NotNull
    public final RistrettoElement negate() {
        return new RistrettoElement(this.representation.negate());
    }

    @NotNull
    public final RistrettoElement double() {
        return new RistrettoElement(this.representation.double());
    }

    @NotNull
    public final RistrettoElement multiply(@NotNull Scalar s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return new RistrettoElement(this.representation.multiply(s));
    }

    @NotNull
    public String toString() {
        return "RistrettoElement(" + this.representation + ')';
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ldev/sublab/curve25519/ristrettoElement/RistrettoElement$Companion;", "", "()V", "IDENTITY", "Ldev/sublab/curve25519/ristrettoElement/RistrettoElement;", "getIDENTITY", "()Ldev/sublab/curve25519/ristrettoElement/RistrettoElement;", "RISTRETTO_GENERATOR", "getRISTRETTO_GENERATOR", "RISTRETTO_GENERATOR_TABLE", "Ldev/sublab/curve25519/ristrettoElement/RistrettoGeneratorTable;", "getRISTRETTO_GENERATOR_TABLE", "()Ldev/sublab/curve25519/ristrettoElement/RistrettoGeneratorTable;", "curve25519-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RistrettoElement getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final RistrettoElement getRISTRETTO_GENERATOR() {
            return RISTRETTO_GENERATOR;
        }

        @NotNull
        public final RistrettoGeneratorTable getRISTRETTO_GENERATOR_TABLE() {
            return RISTRETTO_GENERATOR_TABLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

