/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.curve25519.ristrettoElement;

import dev.sublab.curve25519.InvalidEncodingException;
import dev.sublab.curve25519.edwardsPoint.EdwardsPoint;
import dev.sublab.curve25519.fieldElement.FieldElement;
import dev.sublab.curve25519.fieldElement.SqrtRatioM1Kt;
import dev.sublab.curve25519.fieldElement.SqrtRatioM1Result;
import dev.sublab.curve25519.fieldElement.functions.ByteArrayKt;
import dev.sublab.curve25519.fieldElement.functions.MultiplyKt;
import dev.sublab.curve25519.fieldElement.functions.SquareKt;
import dev.sublab.curve25519.ristrettoElement.RistrettoElement;
import dev.sublab.support.ConstantTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0000J\u0006\u0010\n\u001a\u00020\u000bJ\u0013\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ldev/sublab/curve25519/ristrettoElement/CompressedRistretto;", "", "data", "", "([B)V", "decompressedRepresentation", "Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;", "ctEquals", "", "other", "decompress", "Ldev/sublab/curve25519/ristrettoElement/RistrettoElement;", "equals", "hashCode", "", "toByteArray", "curve25519-kotlin"})
public final class CompressedRistretto {
    @NotNull
    private final byte[] data;
    @Nullable
    private EdwardsPoint decompressedRepresentation;

    public CompressedRistretto(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        if (!(this.data.length == 32)) {
            boolean bl = false;
            String string = "Invalid CompressedRistretto encoding";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final RistrettoElement decompress() throws InvalidEncodingException {
        EdwardsPoint p;
        EdwardsPoint edwardsPoint = this.decompressedRepresentation;
        if (edwardsPoint != null) {
            EdwardsPoint it = edwardsPoint;
            boolean bl = false;
            return new RistrettoElement(it);
        }
        FieldElement s = ByteArrayKt.toFieldElement(this.data);
        byte[] sBytes = ByteArrayKt.toByteArray(s);
        boolean sIsCanonical = ConstantTime.INSTANCE.equal(this.data, sBytes);
        if (!sIsCanonical || s.isNegative()) {
            throw new InvalidEncodingException("Invalid ristretto255 encoding");
        }
        FieldElement ss = SquareKt.square$default(s, 0, 1, null);
        FieldElement u1 = FieldElement.Companion.getONE().subtract(ss);
        FieldElement u2 = FieldElement.Companion.getONE().add(ss);
        FieldElement u2Sqr = SquareKt.square$default(u2, 0, 1, null);
        FieldElement v = MultiplyKt.multiply(FieldElement.Companion.getNEG_EDWARDS_D(), SquareKt.square$default(u1, 0, 1, null)).subtract(u2Sqr);
        SqrtRatioM1Result invsqrt = SqrtRatioM1Kt.sqrtRatioM1(FieldElement.Companion.getONE(), MultiplyKt.multiply(v, u2Sqr));
        FieldElement denX = MultiplyKt.multiply(invsqrt.getResult(), u2);
        FieldElement denY = MultiplyKt.multiply(MultiplyKt.multiply(invsqrt.getResult(), denX), v);
        FieldElement x = MultiplyKt.multiply(s.add(s), denX).ctAbs();
        FieldElement y = MultiplyKt.multiply(u1, denY);
        FieldElement t = MultiplyKt.multiply(x, y);
        if (!invsqrt.getWasSquare() || t.isNegative() || y.isZero()) {
            throw new InvalidEncodingException("Invalid ristretto255 encoding");
        }
        this.decompressedRepresentation = p = new EdwardsPoint(x, y, FieldElement.Companion.getONE(), t);
        return new RistrettoElement(p);
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
        return byArray;
    }

    public final boolean ctEquals(@NotNull CompressedRistretto other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ConstantTime.INSTANCE.equal(this.data, other.data);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof CompressedRistretto)) {
            return false;
        }
        return this.ctEquals((CompressedRistretto)other);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

