/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.curve25519.projectivePoint;

import dev.sublab.curve25519.completedPoint.CompletedPoint;
import dev.sublab.curve25519.edwardsPoint.EdwardsPoint;
import dev.sublab.curve25519.fieldElement.FieldElement;
import dev.sublab.curve25519.fieldElement.functions.MultiplyKt;
import dev.sublab.curve25519.fieldElement.functions.SquareAndDoubleKt;
import dev.sublab.curve25519.fieldElement.functions.SquareKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000f"}, d2={"Ldev/sublab/curve25519/projectivePoint/ProjectivePoint;", "", "x", "Ldev/sublab/curve25519/fieldElement/FieldElement;", "y", "z", "(Ldev/sublab/curve25519/fieldElement/FieldElement;Ldev/sublab/curve25519/fieldElement/FieldElement;Ldev/sublab/curve25519/fieldElement/FieldElement;)V", "getX", "()Ldev/sublab/curve25519/fieldElement/FieldElement;", "getY", "getZ", "double", "Ldev/sublab/curve25519/completedPoint/CompletedPoint;", "toExtended", "Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;", "curve25519-kotlin"})
public final class ProjectivePoint {
    @NotNull
    private final FieldElement x;
    @NotNull
    private final FieldElement y;
    @NotNull
    private final FieldElement z;

    public ProjectivePoint(@NotNull FieldElement x, @NotNull FieldElement y, @NotNull FieldElement z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @NotNull
    public final FieldElement getX() {
        return this.x;
    }

    @NotNull
    public final FieldElement getY() {
        return this.y;
    }

    @NotNull
    public final FieldElement getZ() {
        return this.z;
    }

    @NotNull
    public final EdwardsPoint toExtended() {
        return new EdwardsPoint(MultiplyKt.multiply(this.x, this.z), MultiplyKt.multiply(this.y, this.z), SquareKt.square$default(this.z, 0, 1, null), MultiplyKt.multiply(this.x, this.y));
    }

    @NotNull
    public final CompletedPoint double() {
        FieldElement xx = SquareKt.square$default(this.x, 0, 1, null);
        FieldElement yy = SquareKt.square$default(this.y, 0, 1, null);
        FieldElement zz2 = SquareAndDoubleKt.squareAndDouble(this.z);
        FieldElement xPlusY = this.x.add(this.y);
        FieldElement xPlusYSq = SquareKt.square$default(xPlusY, 0, 1, null);
        FieldElement yyPlusXx = yy.add(xx);
        FieldElement yyMinusXx = yy.subtract(xx);
        return new CompletedPoint(xPlusYSq.subtract(yyPlusXx), yyPlusXx, yyMinusXx, zz2.subtract(yyMinusXx));
    }
}

