/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.curve25519.fieldElement;

import dev.sublab.curve25519.fieldElement.FieldElement;
import dev.sublab.curve25519.fieldElement.functions.ByteArrayKt;
import dev.sublab.curve25519.fieldElement.functions.SquareKt;
import dev.sublab.support.ConstantTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\r\u001a\u00020\u0000J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0000J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0006J\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u0013\u0010\u0014\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Ldev/sublab/curve25519/fieldElement/FieldElement;", "", "t", "", "([I)V", "isNegative", "", "()Z", "isZero", "getT$curve25519_kotlin", "()[I", "add", "value", "ctAbs", "ctEquals", "other", "ctSelect", "that", "b", "", "equals", "hashCode", "negate", "subtract", "toString", "", "Companion", "curve25519-kotlin"})
public final class FieldElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] t;
    @NotNull
    private static final FieldElement ZERO;
    @NotNull
    private static final FieldElement ONE;
    @NotNull
    private static final FieldElement MINUS_ONE;
    @NotNull
    private static final byte[] ZERO_BYTES;
    @NotNull
    private static final FieldElement EDWARDS_D;
    @NotNull
    private static final FieldElement NEG_EDWARDS_D;
    @NotNull
    private static final FieldElement EDWARDS_2D;
    @NotNull
    private static final FieldElement ONE_MINUS_D_SQ;
    @NotNull
    private static final FieldElement D_MINUS_ONE_SQ;
    @NotNull
    private static final FieldElement SQRT_AD_MINUS_ONE;
    @NotNull
    private static final FieldElement INVSQRT_A_MINUS_D;
    @NotNull
    private static final FieldElement SQRT_M1;

    public FieldElement(@NotNull int[] t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.t = t;
        if (!(this.t.length == 10)) {
            boolean bl = false;
            String string = "Invalid radix-2^25.5 representation";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final int[] getT$curve25519_kotlin() {
        return this.t;
    }

    public final boolean ctEquals(@NotNull FieldElement other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ConstantTime.INSTANCE.equal(ByteArrayKt.toByteArray(this), ByteArrayKt.toByteArray(other));
    }

    @NotNull
    public final FieldElement ctSelect(@NotNull FieldElement that, int b) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        int b2 = b;
        b2 = -b2;
        int[] result = new int[10];
        for (int i = 0; i < 10; ++i) {
            result[i] = this.t[i];
            int x = this.t[i] ^ that.t[i];
            result[i] = result[i] ^ (x &= b2);
        }
        return new FieldElement(result);
    }

    @NotNull
    public final FieldElement ctSelect(@NotNull FieldElement that, boolean b) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return this.ctSelect(that, b ? 1 : 0);
    }

    @NotNull
    public final FieldElement ctAbs() {
        return this.ctSelect(this.negate(), this.isNegative());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof FieldElement)) {
            return false;
        }
        return this.ctEquals((FieldElement)other);
    }

    public int hashCode() {
        return Arrays.hashCode(ByteArrayKt.toByteArray(this));
    }

    public final boolean isZero() {
        return ConstantTime.INSTANCE.equal(ByteArrayKt.toByteArray(this), ZERO_BYTES);
    }

    public final boolean isNegative() {
        return (ByteArrayKt.toByteArray(this)[0] & 1) == 1;
    }

    @NotNull
    public final FieldElement add(@NotNull FieldElement value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int[] g = value.t;
        int[] h = new int[10];
        for (int i = 0; i < 10; ++i) {
            h[i] = this.t[i] + g[i];
        }
        return new FieldElement(h);
    }

    @NotNull
    public final FieldElement subtract(@NotNull FieldElement value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int[] g = value.t;
        int[] h = new int[10];
        for (int i = 0; i < 10; ++i) {
            h[i] = this.t[i] - g[i];
        }
        return new FieldElement(h);
    }

    @NotNull
    public final FieldElement negate() {
        int[] h = new int[10];
        for (int i = 0; i < 10; ++i) {
            h[i] = -this.t[i];
        }
        return new FieldElement(h);
    }

    @NotNull
    public String toString() {
        return "FieldElement([" + ArraysKt.joinToString$default((int[])this.t, (CharSequence)", ", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null) + "])";
    }

    static {
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ZERO = new FieldElement(nArray);
        nArray = new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        ONE = new FieldElement(nArray);
        MINUS_ONE = ZERO.subtract(ONE);
        ZERO_BYTES = new byte[32];
        nArray = new int[]{-10913610, 13857413, -15372611, 6949391, 114729, -8787816, -6275908, -3247719, -18696448, -12055116};
        EDWARDS_D = new FieldElement(nArray);
        NEG_EDWARDS_D = EDWARDS_D.negate();
        nArray = new int[]{-21827239, -5839606, -30745221, 13898782, 229458, 15978800, -12551817, -6495438, 29715968, 9444199};
        EDWARDS_2D = new FieldElement(nArray);
        ONE_MINUS_D_SQ = ONE.subtract(SquareKt.square$default(EDWARDS_D, 0, 1, null));
        D_MINUS_ONE_SQ = SquareKt.square$default(EDWARDS_D.subtract(ONE), 0, 1, null);
        nArray = new int[]{24849947, -153582, -23613485, 6347715, -21072328, -667138, -25271143, -15367704, -870347, 14525639};
        SQRT_AD_MINUS_ONE = new FieldElement(nArray);
        nArray = new int[]{6111485, 4156064, -27798727, 12243468, -25904040, 120897, 20826367, -7060776, 6093568, -1986012};
        INVSQRT_A_MINUS_D = new FieldElement(nArray);
        nArray = new int[]{-32595792, -7943725, 9377950, 3500415, 12389472, -272473, -25146209, -2005654, 326686, 11406482};
        SQRT_M1 = new FieldElement(nArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Ldev/sublab/curve25519/fieldElement/FieldElement$Companion;", "", "()V", "D_MINUS_ONE_SQ", "Ldev/sublab/curve25519/fieldElement/FieldElement;", "getD_MINUS_ONE_SQ", "()Ldev/sublab/curve25519/fieldElement/FieldElement;", "EDWARDS_2D", "getEDWARDS_2D", "EDWARDS_D", "getEDWARDS_D", "INVSQRT_A_MINUS_D", "getINVSQRT_A_MINUS_D", "MINUS_ONE", "getMINUS_ONE", "NEG_EDWARDS_D", "getNEG_EDWARDS_D", "ONE", "getONE", "ONE_MINUS_D_SQ", "getONE_MINUS_D_SQ", "SQRT_AD_MINUS_ONE", "getSQRT_AD_MINUS_ONE", "SQRT_M1", "getSQRT_M1", "ZERO", "getZERO", "ZERO_BYTES", "", "getZERO_BYTES", "()[B", "curve25519-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FieldElement getZERO() {
            return ZERO;
        }

        @NotNull
        public final FieldElement getONE() {
            return ONE;
        }

        @NotNull
        public final FieldElement getMINUS_ONE() {
            return MINUS_ONE;
        }

        @NotNull
        public final byte[] getZERO_BYTES() {
            return ZERO_BYTES;
        }

        @NotNull
        public final FieldElement getEDWARDS_D() {
            return EDWARDS_D;
        }

        @NotNull
        public final FieldElement getNEG_EDWARDS_D() {
            return NEG_EDWARDS_D;
        }

        @NotNull
        public final FieldElement getEDWARDS_2D() {
            return EDWARDS_2D;
        }

        @NotNull
        public final FieldElement getONE_MINUS_D_SQ() {
            return ONE_MINUS_D_SQ;
        }

        @NotNull
        public final FieldElement getD_MINUS_ONE_SQ() {
            return D_MINUS_ONE_SQ;
        }

        @NotNull
        public final FieldElement getSQRT_AD_MINUS_ONE() {
            return SQRT_AD_MINUS_ONE;
        }

        @NotNull
        public final FieldElement getINVSQRT_A_MINUS_D() {
            return INVSQRT_A_MINUS_D;
        }

        @NotNull
        public final FieldElement getSQRT_M1() {
            return SQRT_M1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

