/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.curve25519.edwardsPoint.functions;

import dev.sublab.curve25519.affineNielsPoint.AffineNielsPoint;
import dev.sublab.curve25519.affineNielsPoint.NafLookupTable;
import dev.sublab.curve25519.completedPoint.CompletedPoint;
import dev.sublab.curve25519.edwardsPoint.EdwardsPoint;
import dev.sublab.curve25519.projectiveNielsPoint.ProjectiveNielsPoint;
import dev.sublab.curve25519.projectiveNielsPoint.functions.BuildNafLookupTableKt;
import dev.sublab.curve25519.projectivePoint.ProjectivePoint;
import dev.sublab.curve25519.scalar.Scalar;
import dev.sublab.curve25519.scalar.functions.NonAdjacentFormKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0003\u00a8\u0006\u0006"}, d2={"vartimeDoubleScalarMultiplyBasepoint", "Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;", "a", "Ldev/sublab/curve25519/scalar/Scalar;", "ep", "b", "curve25519-kotlin"})
public final class VartimeDoubleScalarMultiplyBasepointKt {
    @NotNull
    public static final EdwardsPoint vartimeDoubleScalarMultiplyBasepoint(@NotNull Scalar a, @NotNull EdwardsPoint ep, @NotNull Scalar b) {
        int i;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)ep, (String)"ep");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        byte[] aNaf = NonAdjacentFormKt.nonAdjacentForm(a);
        byte[] bNaf = NonAdjacentFormKt.nonAdjacentForm(b);
        dev.sublab.curve25519.projectiveNielsPoint.NafLookupTable tableA = BuildNafLookupTableKt.buildNafLookupTable(ProjectiveNielsPoint.Companion, ep);
        NafLookupTable tableB = AffineNielsPoint.Companion.getAFFINE_ODD_MULTIPLES_OF_BASEPOINT();
        for (i = 255; i >= 0 && aNaf[i] == 0 && bNaf[i] == 0; --i) {
        }
        ProjectivePoint r = EdwardsPoint.Companion.getIDENTITY().toProjective$curve25519_kotlin();
        while (i >= 0) {
            CompletedPoint t = r.double();
            if (aNaf[i] > 0) {
                t = t.toExtended().add$curve25519_kotlin((ProjectiveNielsPoint)tableA.select(aNaf[i]));
            } else if (aNaf[i] < 0) {
                t = t.toExtended().subtract$curve25519_kotlin(tableA.select((int)(-aNaf[i])));
            }
            if (bNaf[i] > 0) {
                t = t.toExtended().add$curve25519_kotlin((AffineNielsPoint)tableB.select(bNaf[i]));
            } else if (bNaf[i] < 0) {
                t = t.toExtended().subtract$curve25519_kotlin(tableB.select((int)(-bNaf[i])));
            }
            r = t.toProjective();
            --i;
        }
        return r.toExtended();
    }
}

