/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.curve25519.edwardsPoint;

import dev.sublab.curve25519.affineNielsPoint.AffineNielsPoint;
import dev.sublab.curve25519.completedPoint.CompletedPoint;
import dev.sublab.curve25519.edwardsPoint.CompressedEdwardsY;
import dev.sublab.curve25519.edwardsPoint.EdwardsBasepointTable;
import dev.sublab.curve25519.fieldElement.FieldElement;
import dev.sublab.curve25519.fieldElement.functions.ByteArrayKt;
import dev.sublab.curve25519.fieldElement.functions.InvertKt;
import dev.sublab.curve25519.fieldElement.functions.MultiplyKt;
import dev.sublab.curve25519.projectiveNielsPoint.LookupTable;
import dev.sublab.curve25519.projectiveNielsPoint.ProjectiveNielsPoint;
import dev.sublab.curve25519.projectiveNielsPoint.functions.BuildLookupTableKt;
import dev.sublab.curve25519.projectivePoint.ProjectivePoint;
import dev.sublab.curve25519.scalar.Scalar;
import dev.sublab.curve25519.scalar.functions.Radix16Kt;
import dev.sublab.curve25519.unpackedScalar.UnpackedScalar;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 C2\u00020\u0001:\u0001CB'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000J\u0015\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020$H\u0000\u00a2\u0006\u0002\b#J\u0006\u0010%\u001a\u00020&J\u0015\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b)J\u0016\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020\u0000J\u0013\u0010/\u001a\u00020\t2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00100\u001a\u00020-H\u0016J\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u000203J\b\u00104\u001a\u00020\u0000H\u0002J\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020-J\u0006\u00107\u001a\u00020\u0000J\u0015\u00108\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b9J\u000e\u00108\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0000J\u0015\u00108\u001a\u00020 2\u0006\u0010!\u001a\u00020$H\u0000\u00a2\u0006\u0002\b9J\r\u0010:\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b;J\r\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\b>J\r\u0010?\u001a\u00020$H\u0000\u00a2\u0006\u0002\b@J\b\u0010A\u001a\u00020BH\u0016R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0011\u0010\u000b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0013\u001a\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0012\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0012\u001a\u0004\b\u0018\u0010\u0015R\u0014\u0010\u0006\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001b\u00a8\u0006D"}, d2={"Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;", "", "x", "Ldev/sublab/curve25519/fieldElement/FieldElement;", "y", "z", "t", "(Ldev/sublab/curve25519/fieldElement/FieldElement;Ldev/sublab/curve25519/fieldElement/FieldElement;Ldev/sublab/curve25519/fieldElement/FieldElement;Ldev/sublab/curve25519/fieldElement/FieldElement;)V", "isIdentity", "", "()Z", "isSmallOrder", "isTorsionFree", "lookupTable", "Ldev/sublab/curve25519/projectiveNielsPoint/LookupTable;", "getLookupTable", "()Ldev/sublab/curve25519/projectiveNielsPoint/LookupTable;", "lookupTable$delegate", "Lkotlin/Lazy;", "multipliedByBasePointOrder", "getMultipliedByBasePointOrder", "()Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;", "multipliedByBasePointOrder$delegate", "multipliedByCofactor", "getMultipliedByCofactor", "multipliedByCofactor$delegate", "getT$curve25519_kotlin", "()Ldev/sublab/curve25519/fieldElement/FieldElement;", "getX$curve25519_kotlin", "getY$curve25519_kotlin", "getZ$curve25519_kotlin", "add", "Ldev/sublab/curve25519/completedPoint/CompletedPoint;", "q", "Ldev/sublab/curve25519/affineNielsPoint/AffineNielsPoint;", "add$curve25519_kotlin", "Ldev/sublab/curve25519/projectiveNielsPoint/ProjectiveNielsPoint;", "compress", "Ldev/sublab/curve25519/edwardsPoint/CompressedEdwardsY;", "ctEquals", "other", "ctEquals$curve25519_kotlin", "ctSelect", "that", "b", "", "double", "equals", "hashCode", "multiply", "s", "Ldev/sublab/curve25519/scalar/Scalar;", "multiplyByCofactor", "multiplyByPow2", "k", "negate", "subtract", "subtract$curve25519_kotlin", "toAffineNiels", "toAffineNiels$curve25519_kotlin", "toProjective", "Ldev/sublab/curve25519/projectivePoint/ProjectivePoint;", "toProjective$curve25519_kotlin", "toProjectiveNiels", "toProjectiveNiels$curve25519_kotlin", "toString", "", "Companion", "curve25519-kotlin"})
public final class EdwardsPoint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FieldElement x;
    @NotNull
    private final FieldElement y;
    @NotNull
    private final FieldElement z;
    @NotNull
    private final FieldElement t;
    @NotNull
    private final Lazy lookupTable$delegate;
    @NotNull
    private final Lazy multipliedByCofactor$delegate;
    @NotNull
    private final Lazy multipliedByBasePointOrder$delegate;
    @NotNull
    private static final EdwardsPoint IDENTITY = new EdwardsPoint(FieldElement.Companion.getZERO(), FieldElement.Companion.getONE(), FieldElement.Companion.getONE(), FieldElement.Companion.getZERO());
    @NotNull
    private static final EdwardsPoint ED25519_BASEPOINT;
    @NotNull
    private static final EdwardsBasepointTable ED25519_BASEPOINT_TABLE;

    public EdwardsPoint(@NotNull FieldElement x, @NotNull FieldElement y, @NotNull FieldElement z, @NotNull FieldElement t) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.x = x;
        this.y = y;
        this.z = z;
        this.t = t;
        this.lookupTable$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LookupTable>(this){
            final /* synthetic */ EdwardsPoint this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final LookupTable invoke() {
                return BuildLookupTableKt.buildLookupTable(ProjectiveNielsPoint.Companion, this.this$0);
            }
        }));
        this.multipliedByCofactor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EdwardsPoint>(this){
            final /* synthetic */ EdwardsPoint this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EdwardsPoint invoke() {
                return EdwardsPoint.access$multiplyByCofactor(this.this$0);
            }
        }));
        this.multipliedByBasePointOrder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EdwardsPoint>(this){
            final /* synthetic */ EdwardsPoint this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EdwardsPoint invoke() {
                return this.this$0.multiply(UnpackedScalar.Companion.getBASEPOINT_ORDER());
            }
        }));
    }

    @NotNull
    public final FieldElement getX$curve25519_kotlin() {
        return this.x;
    }

    @NotNull
    public final FieldElement getY$curve25519_kotlin() {
        return this.y;
    }

    @NotNull
    public final FieldElement getZ$curve25519_kotlin() {
        return this.z;
    }

    @NotNull
    public final FieldElement getT$curve25519_kotlin() {
        return this.t;
    }

    @NotNull
    public final CompressedEdwardsY compress() {
        FieldElement recip = InvertKt.invert(this.z);
        FieldElement x = MultiplyKt.multiply(this.x, recip);
        FieldElement y = MultiplyKt.multiply(this.y, recip);
        byte[] s = ByteArrayKt.toByteArray(y);
        int xIsNegative = x.isNegative() ? 1 : 0;
        s[31] = (byte)(s[31] | (byte)(xIsNegative << 7));
        return new CompressedEdwardsY(s);
    }

    public final boolean ctEquals$curve25519_kotlin(@NotNull EdwardsPoint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.compress().ctEquals(other.compress());
    }

    @NotNull
    public final EdwardsPoint ctSelect(@NotNull EdwardsPoint that, int b) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return new EdwardsPoint(this.x.ctSelect(that.x, b), this.y.ctSelect(that.y, b), this.z.ctSelect(that.z, b), this.t.ctSelect(that.t, b));
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof EdwardsPoint)) {
            return false;
        }
        return this.ctEquals$curve25519_kotlin((EdwardsPoint)other);
    }

    public int hashCode() {
        return this.compress().hashCode();
    }

    @NotNull
    public final ProjectivePoint toProjective$curve25519_kotlin() {
        return new ProjectivePoint(this.x, this.y, this.z);
    }

    @NotNull
    public final ProjectiveNielsPoint toProjectiveNiels$curve25519_kotlin() {
        return new ProjectiveNielsPoint(this.y.add(this.x), this.y.subtract(this.x), this.z, MultiplyKt.multiply(this.t, FieldElement.Companion.getEDWARDS_2D()));
    }

    @NotNull
    public final AffineNielsPoint toAffineNiels$curve25519_kotlin() {
        FieldElement recip = InvertKt.invert(this.z);
        FieldElement x = MultiplyKt.multiply(this.x, recip);
        FieldElement y = MultiplyKt.multiply(this.y, recip);
        FieldElement xy2D = MultiplyKt.multiply(MultiplyKt.multiply(x, y), FieldElement.Companion.getEDWARDS_2D());
        return new AffineNielsPoint(y.add(x), y.subtract(x), xy2D);
    }

    @NotNull
    public final EdwardsPoint add(@NotNull EdwardsPoint q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return this.add$curve25519_kotlin(q.toProjectiveNiels$curve25519_kotlin()).toExtended();
    }

    @NotNull
    public final CompletedPoint add$curve25519_kotlin(@NotNull ProjectiveNielsPoint q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        FieldElement yPlusX = this.y.add(this.x);
        FieldElement yMinusX = this.y.subtract(this.x);
        FieldElement pp = MultiplyKt.multiply(yPlusX, q.getYPlusX());
        FieldElement mm = MultiplyKt.multiply(yMinusX, q.getYMinusX());
        FieldElement tt2d = MultiplyKt.multiply(this.t, q.getT2D());
        FieldElement zz = MultiplyKt.multiply(this.z, q.getZ());
        FieldElement zz2 = zz.add(zz);
        return new CompletedPoint(pp.subtract(mm), pp.add(mm), zz2.add(tt2d), zz2.subtract(tt2d));
    }

    @NotNull
    public final CompletedPoint add$curve25519_kotlin(@NotNull AffineNielsPoint q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        FieldElement yPlusX = this.y.add(this.x);
        FieldElement yMinusX = this.y.subtract(this.x);
        FieldElement pp = MultiplyKt.multiply(yPlusX, q.getYPlusX());
        FieldElement mm = MultiplyKt.multiply(yMinusX, q.getYMinusX());
        FieldElement txy2D = MultiplyKt.multiply(this.t, q.getXy2D());
        FieldElement z2 = this.z.add(this.z);
        return new CompletedPoint(pp.subtract(mm), pp.add(mm), z2.add(txy2D), z2.subtract(txy2D));
    }

    @NotNull
    public final EdwardsPoint subtract(@NotNull EdwardsPoint q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        return this.subtract$curve25519_kotlin(q.toProjectiveNiels$curve25519_kotlin()).toExtended();
    }

    @NotNull
    public final CompletedPoint subtract$curve25519_kotlin(@NotNull ProjectiveNielsPoint q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        FieldElement yPlusX = this.y.add(this.x);
        FieldElement yMinusX = this.y.subtract(this.x);
        FieldElement pm = MultiplyKt.multiply(yPlusX, q.getYMinusX());
        FieldElement mp = MultiplyKt.multiply(yMinusX, q.getYPlusX());
        FieldElement tt2d = MultiplyKt.multiply(this.t, q.getT2D());
        FieldElement zz = MultiplyKt.multiply(this.z, q.getZ());
        FieldElement zz2 = zz.add(zz);
        return new CompletedPoint(pm.subtract(mp), pm.add(mp), zz2.subtract(tt2d), zz2.add(tt2d));
    }

    @NotNull
    public final CompletedPoint subtract$curve25519_kotlin(@NotNull AffineNielsPoint q) {
        Intrinsics.checkNotNullParameter((Object)q, (String)"q");
        FieldElement yPlusX = this.y.add(this.x);
        FieldElement yMinusX = this.y.subtract(this.x);
        FieldElement pm = MultiplyKt.multiply(yPlusX, q.getYMinusX());
        FieldElement mp = MultiplyKt.multiply(yMinusX, q.getYPlusX());
        FieldElement txy2D = MultiplyKt.multiply(this.t, q.getXy2D());
        FieldElement z2 = this.z.add(this.z);
        return new CompletedPoint(pm.subtract(mp), pm.add(mp), z2.subtract(txy2D), z2.add(txy2D));
    }

    @NotNull
    public final EdwardsPoint negate() {
        return new EdwardsPoint(this.x.negate(), this.y, this.z, this.t.negate());
    }

    @NotNull
    public final EdwardsPoint double() {
        return this.toProjective$curve25519_kotlin().double().toExtended();
    }

    @NotNull
    public final EdwardsPoint multiply(@NotNull Scalar s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        LookupTable lookupTable2 = this.getLookupTable();
        byte[] e = Radix16Kt.toRadix16(s);
        EdwardsPoint q = IDENTITY;
        for (int i = 63; -1 < i; --i) {
            q = q.multiplyByPow2(4);
            q = q.add$curve25519_kotlin((ProjectiveNielsPoint)lookupTable2.select(e[i])).toExtended();
        }
        return q;
    }

    private final LookupTable getLookupTable() {
        Lazy lazy = this.lookupTable$delegate;
        return (LookupTable)lazy.getValue();
    }

    private final EdwardsPoint multiplyByCofactor() {
        return this.multiplyByPow2(3);
    }

    @NotNull
    public final EdwardsPoint multiplyByPow2(int k) {
        if (!(k > 0)) {
            boolean $i$a$-require-EdwardsPoint$multiplyByPow2$22 = false;
            String $i$a$-require-EdwardsPoint$multiplyByPow2$22 = "Exponent must be positive and non-zero";
            throw new IllegalArgumentException($i$a$-require-EdwardsPoint$multiplyByPow2$22.toString());
        }
        ProjectivePoint s = this.toProjective$curve25519_kotlin();
        int n = k - 1;
        for (int i = 0; i < n; ++i) {
            s = s.double().toProjective();
        }
        return s.double().toExtended();
    }

    public final boolean isIdentity() {
        return this.ctEquals$curve25519_kotlin(IDENTITY);
    }

    public final boolean isSmallOrder() {
        return this.getMultipliedByCofactor().isIdentity();
    }

    private final EdwardsPoint getMultipliedByCofactor() {
        Lazy lazy = this.multipliedByCofactor$delegate;
        return (EdwardsPoint)lazy.getValue();
    }

    public final boolean isTorsionFree() {
        return this.getMultipliedByBasePointOrder().isIdentity();
    }

    private final EdwardsPoint getMultipliedByBasePointOrder() {
        Lazy lazy = this.multipliedByBasePointOrder$delegate;
        return (EdwardsPoint)lazy.getValue();
    }

    @NotNull
    public String toString() {
        return StringsKt.trimIndent((String)("\n            EdwardsPoint(\n                x: " + this.x + ",\n                y: " + this.y + ",\n                z: " + this.z + ",\n                t: " + this.t + "\n            )\n        "));
    }

    public static final /* synthetic */ EdwardsPoint access$multiplyByCofactor(EdwardsPoint $this) {
        return $this.multiplyByCofactor();
    }

    static {
        int[] nArray = new int[]{-14297830, -7645148, 16144683, -16471763, 27570974, -2696100, -26142465, 8378389, 20764389, 8758491};
        FieldElement fieldElement = new FieldElement(nArray);
        nArray = new int[]{-26843541, -6710886, 0xCCCCCD, -13421773, 0x199999A, 0x666666, -13421773, 0xCCCCCD, -26843546, -6710886};
        FieldElement fieldElement2 = new FieldElement(nArray);
        nArray = new int[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        FieldElement fieldElement3 = new FieldElement(nArray);
        nArray = new int[]{28827062, -6116119, -27349572, 244363, 8635006, 11264893, 19351346, 0xCCACDD, 16611511, -6414980};
        ED25519_BASEPOINT = new EdwardsPoint(fieldElement, fieldElement2, fieldElement3, new FieldElement(nArray));
        ED25519_BASEPOINT_TABLE = new EdwardsBasepointTable(ED25519_BASEPOINT);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint$Companion;", "", "()V", "ED25519_BASEPOINT", "Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;", "getED25519_BASEPOINT", "()Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;", "ED25519_BASEPOINT_TABLE", "Ldev/sublab/curve25519/edwardsPoint/EdwardsBasepointTable;", "getED25519_BASEPOINT_TABLE", "()Ldev/sublab/curve25519/edwardsPoint/EdwardsBasepointTable;", "IDENTITY", "getIDENTITY", "curve25519-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EdwardsPoint getIDENTITY() {
            return IDENTITY;
        }

        @NotNull
        public final EdwardsPoint getED25519_BASEPOINT() {
            return ED25519_BASEPOINT;
        }

        @NotNull
        public final EdwardsBasepointTable getED25519_BASEPOINT_TABLE() {
            return ED25519_BASEPOINT_TABLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

