/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.curve25519.edwardsPoint;

import dev.sublab.curve25519.affineNielsPoint.AffineNielsPoint;
import dev.sublab.curve25519.affineNielsPoint.LookupTable;
import dev.sublab.curve25519.edwardsPoint.EdwardsBasepointTableKt;
import dev.sublab.curve25519.edwardsPoint.EdwardsPoint;
import dev.sublab.curve25519.scalar.Scalar;
import dev.sublab.curve25519.scalar.functions.Radix16Kt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\f"}, d2={"Ldev/sublab/curve25519/edwardsPoint/EdwardsBasepointTable;", "", "basepoint", "Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;", "(Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;)V", "tables", "", "Ldev/sublab/curve25519/affineNielsPoint/LookupTable;", "[Ldev/sublab/curve25519/affineNielsPoint/LookupTable;", "multiply", "s", "Ldev/sublab/curve25519/scalar/Scalar;", "curve25519-kotlin"})
public final class EdwardsBasepointTable {
    @NotNull
    private final LookupTable[] tables;

    public EdwardsBasepointTable(@NotNull EdwardsPoint basepoint) {
        Intrinsics.checkNotNullParameter((Object)basepoint, (String)"basepoint");
        this.tables = EdwardsBasepointTableKt.access$buildLookupTables(basepoint);
    }

    @NotNull
    public final EdwardsPoint multiply(@NotNull Scalar s) {
        int i;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        byte[] e = Radix16Kt.toRadix16(s);
        EdwardsPoint h = EdwardsPoint.Companion.getIDENTITY();
        for (i = 1; i < 64; i += 2) {
            h = h.add$curve25519_kotlin((AffineNielsPoint)this.tables[i / 2].select(e[i])).toExtended();
        }
        h = h.multiplyByPow2(4);
        for (i = 0; i < 64; i += 2) {
            h = h.add$curve25519_kotlin((AffineNielsPoint)this.tables[i / 2].select(e[i])).toExtended();
        }
        return h;
    }
}

