/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.curve25519.edwardsPoint;

import dev.sublab.curve25519.InvalidEncodingException;
import dev.sublab.curve25519.edwardsPoint.EdwardsPoint;
import dev.sublab.curve25519.fieldElement.FieldElement;
import dev.sublab.curve25519.fieldElement.SqrtRatioM1Kt;
import dev.sublab.curve25519.fieldElement.SqrtRatioM1Result;
import dev.sublab.curve25519.fieldElement.functions.ByteArrayKt;
import dev.sublab.curve25519.fieldElement.functions.MultiplyKt;
import dev.sublab.curve25519.fieldElement.functions.SquareKt;
import dev.sublab.support.ConstantTime;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0000J\u0006\u0010\b\u001a\u00020\tJ\u0013\u0010\n\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0006\u0010\r\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ldev/sublab/curve25519/edwardsPoint/CompressedEdwardsY;", "", "data", "", "([B)V", "ctEquals", "", "other", "decompress", "Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;", "equals", "hashCode", "", "toByteArray", "curve25519-kotlin"})
public final class CompressedEdwardsY {
    @NotNull
    private final byte[] data;

    public CompressedEdwardsY(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        if (!(this.data.length == 32)) {
            boolean bl = false;
            String string = "Invalid CompressedEdwardsY encoding";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final EdwardsPoint decompress() throws InvalidEncodingException {
        FieldElement v;
        FieldElement y = ByteArrayKt.toFieldElement(this.data);
        FieldElement yy = SquareKt.square$default(y, 0, 1, null);
        FieldElement u = yy.subtract(FieldElement.Companion.getONE());
        SqrtRatioM1Result sqrt = SqrtRatioM1Kt.sqrtRatioM1(u, v = MultiplyKt.multiply(yy, FieldElement.Companion.getEDWARDS_D()).add(FieldElement.Companion.getONE()));
        if (!sqrt.getWasSquare()) {
            throw new InvalidEncodingException("not a valid EdwardsPoint");
        }
        FieldElement x = sqrt.getResult().negate().ctSelect(sqrt.getResult(), ConstantTime.INSTANCE.equal(sqrt.getResult().isNegative(), ConstantTime.INSTANCE.bit(this.data, 255)));
        return new EdwardsPoint(x, y, FieldElement.Companion.getONE(), MultiplyKt.multiply(x, y));
    }

    @NotNull
    public final byte[] toByteArray() {
        byte[] byArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
        return byArray;
    }

    public final boolean ctEquals(@NotNull CompressedEdwardsY other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ConstantTime.INSTANCE.equal(this.data, other.data);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof CompressedEdwardsY)) {
            return false;
        }
        return this.ctEquals((CompressedEdwardsY)other);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

