/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.curve25519.completedPoint;

import dev.sublab.curve25519.edwardsPoint.EdwardsPoint;
import dev.sublab.curve25519.fieldElement.FieldElement;
import dev.sublab.curve25519.fieldElement.functions.MultiplyKt;
import dev.sublab.curve25519.projectivePoint.ProjectivePoint;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0011"}, d2={"Ldev/sublab/curve25519/completedPoint/CompletedPoint;", "", "x", "Ldev/sublab/curve25519/fieldElement/FieldElement;", "y", "z", "t", "(Ldev/sublab/curve25519/fieldElement/FieldElement;Ldev/sublab/curve25519/fieldElement/FieldElement;Ldev/sublab/curve25519/fieldElement/FieldElement;Ldev/sublab/curve25519/fieldElement/FieldElement;)V", "getT", "()Ldev/sublab/curve25519/fieldElement/FieldElement;", "getX", "getY", "getZ", "toExtended", "Ldev/sublab/curve25519/edwardsPoint/EdwardsPoint;", "toProjective", "Ldev/sublab/curve25519/projectivePoint/ProjectivePoint;", "curve25519-kotlin"})
public final class CompletedPoint {
    @NotNull
    private final FieldElement x;
    @NotNull
    private final FieldElement y;
    @NotNull
    private final FieldElement z;
    @NotNull
    private final FieldElement t;

    public CompletedPoint(@NotNull FieldElement x, @NotNull FieldElement y, @NotNull FieldElement z, @NotNull FieldElement t) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.x = x;
        this.y = y;
        this.z = z;
        this.t = t;
    }

    @NotNull
    public final FieldElement getX() {
        return this.x;
    }

    @NotNull
    public final FieldElement getY() {
        return this.y;
    }

    @NotNull
    public final FieldElement getZ() {
        return this.z;
    }

    @NotNull
    public final FieldElement getT() {
        return this.t;
    }

    @NotNull
    public final ProjectivePoint toProjective() {
        return new ProjectivePoint(MultiplyKt.multiply(this.x, this.t), MultiplyKt.multiply(this.y, this.z), MultiplyKt.multiply(this.z, this.t));
    }

    @NotNull
    public final EdwardsPoint toExtended() {
        return new EdwardsPoint(MultiplyKt.multiply(this.x, this.t), MultiplyKt.multiply(this.y, this.z), MultiplyKt.multiply(this.z, this.t), MultiplyKt.multiply(this.x, this.y));
    }
}

