/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.common.numerics;

import dev.sublab.common.numerics.Int128;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0013\b\u0016\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bB\u0013\b\u0016\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u00a2\u0006\u0002\u0010\fB\u0013\b\u0016\u0012\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f\u00a2\u0006\u0002\u0010\u0010B\u0013\b\u0016\u0012\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013\u00a2\u0006\u0002\u0010\u0014B\u000f\b\u0016\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017B\r\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\t\u0010\u001d\u001a\u00020\u0019H\u00c6\u0003J\u0013\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u000eH\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"Ldev/sublab/common/numerics/Int256;", "", "stringValue", "", "(Ljava/lang/String;)V", "int8Value", "", "Ldev/sublab/common/numerics/Int8;", "(B)V", "int16Value", "", "Ldev/sublab/common/numerics/Int16;", "(S)V", "int32Value", "", "Ldev/sublab/common/numerics/Int32;", "(I)V", "int64Value", "", "Ldev/sublab/common/numerics/Int64;", "(J)V", "int128Value", "Ldev/sublab/common/numerics/Int128;", "(Ldev/sublab/common/numerics/Int128;)V", "value", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)V", "getValue", "()Ljava/math/BigInteger;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "common-kotlin"})
public final class Int256 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInteger value;
    public static final int SIZE_BYTES = 32;

    public Int256(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final BigInteger getValue() {
        return this.value;
    }

    public Int256(@NotNull String stringValue) {
        Intrinsics.checkNotNullParameter((Object)stringValue, (String)"stringValue");
        this(new BigInteger(stringValue));
    }

    public Int256(byte int8Value) {
        this((int)int8Value);
    }

    public Int256(short int16Value) {
        this((int)int16Value);
    }

    public Int256(int int32Value) {
        BigInteger bigInteger = BigInteger.valueOf(int32Value);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(this.toLong())");
        this(bigInteger);
    }

    public Int256(long int64Value) {
        BigInteger bigInteger = BigInteger.valueOf(int64Value);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(this)");
        this(bigInteger);
    }

    public Int256(@NotNull Int128 int128Value) {
        Intrinsics.checkNotNullParameter((Object)int128Value, (String)"int128Value");
        this(int128Value.getValue());
    }

    @NotNull
    public final BigInteger component1() {
        return this.value;
    }

    @NotNull
    public final Int256 copy(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new Int256(value);
    }

    public static /* synthetic */ Int256 copy$default(Int256 int256, BigInteger bigInteger, int n, Object object) {
        if ((n & 1) != 0) {
            bigInteger = int256.value;
        }
        return int256.copy(bigInteger);
    }

    @NotNull
    public String toString() {
        return "Int256(value=" + this.value + ')';
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Int256)) {
            return false;
        }
        Int256 int256 = (Int256)other;
        return Intrinsics.areEqual((Object)this.value, (Object)int256.value);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldev/sublab/common/numerics/Int256$Companion;", "", "()V", "SIZE_BYTES", "", "common-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

