/*
 * Decompiled with CFR 0.152.
 */
package dev.sublab.common.numerics;

import dev.sublab.common.numerics.Int128;
import dev.sublab.common.numerics.Int256;
import dev.sublab.common.numerics.Int512;
import dev.sublab.common.numerics.InvalidNumericType;
import dev.sublab.common.numerics.UInt128;
import dev.sublab.common.numerics.UInt256;
import dev.sublab.common.numerics.UInt512;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntProgression;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u00052\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0000\u00a8\u0006\u0006"}, d2={"byteRangeForNumeric", "Lkotlin/ranges/IntProgression;", "type", "Lkotlin/reflect/KClass;", "byteSize", "", "common-kotlin"})
public final class HelperKt {
    public static final int byteSize(@NotNull KClass<?> type) {
        int n;
        Intrinsics.checkNotNullParameter(type, (String)"type");
        KClass<?> kClass = type;
        if (((Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE)) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(UByte.class))) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(UByte.class))) {
            n = 1;
        } else if (((Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE)) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(UShort.class))) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(UShort.class))) {
            n = 2;
        } else if (((Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(UInt.class))) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(UInt.class))) {
            n = 4;
        } else if (((Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE)) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(ULong.class))) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(ULong.class))) {
            n = 8;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Int128.class)) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(UInt128.class))) {
            n = 16;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Int256.class)) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(UInt256.class))) {
            n = 32;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Int512.class)) ? true : Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(UInt512.class))) {
            n = 64;
        } else {
            throw new InvalidNumericType();
        }
        return n;
    }

    @NotNull
    public static final IntProgression byteRangeForNumeric(@NotNull KClass<?> type) throws InvalidNumericType {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        return RangesKt.step((IntProgression)((IntProgression)new IntRange(0, (HelperKt.byteSize(type) - 1) * 8)), (int)8);
    }
}

