/*
 * Decompiled with CFR 0.152.
 */
package dev.strela.v1.minecraftstatefulsetspec.template.spec.template.spec.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Pattern;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"medium", "sizeLimit"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class EmptyDir
implements KubernetesResource {
    @JsonProperty(value="medium")
    @JsonPropertyDescription(value="medium represents what type of storage medium should back this directory.\nThe default is \"\" which means to use the node's default medium.\nMust be an empty string (default) or Memory.\nMore info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir")
    @JsonSetter(nulls=Nulls.SKIP)
    private String medium;
    @JsonProperty(value="sizeLimit")
    @Pattern(value="^(\\+|-)?(([0-9]+(\\.[0-9]*)?)|(\\.[0-9]+))(([KMGTPE]i)|[numkMGTPE]|([eE](\\+|-)?(([0-9]+(\\.[0-9]*)?)|(\\.[0-9]+))))?$")
    @JsonPropertyDescription(value="sizeLimit is the total amount of local storage required for this EmptyDir volume.\nThe size limit is also applicable for memory medium.\nThe maximum usage on memory medium EmptyDir would be the minimum value between\nthe SizeLimit specified here and the sum of memory limits of all containers in a pod.\nThe default is nil which means that the limit is undefined.\nMore info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir")
    @JsonSetter(nulls=Nulls.SKIP)
    private IntOrString sizeLimit;

    public String getMedium() {
        return this.medium;
    }

    public void setMedium(String medium) {
        this.medium = medium;
    }

    public IntOrString getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(IntOrString sizeLimit) {
        this.sizeLimit = sizeLimit;
    }
}

