/*
 * Decompiled with CFR 0.152.
 */
package dev.strela.v1.minecraftstatefulsetspec.template.spec.template.spec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import dev.strela.v1.minecraftstatefulsetspec.template.spec.template.spec.securitycontext.SeLinuxOptions;
import dev.strela.v1.minecraftstatefulsetspec.template.spec.template.spec.securitycontext.SeccompProfile;
import dev.strela.v1.minecraftstatefulsetspec.template.spec.template.spec.securitycontext.Sysctls;
import dev.strela.v1.minecraftstatefulsetspec.template.spec.template.spec.securitycontext.WindowsOptions;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fsGroup", "fsGroupChangePolicy", "runAsGroup", "runAsNonRoot", "runAsUser", "seLinuxOptions", "seccompProfile", "supplementalGroups", "sysctls", "windowsOptions"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class SecurityContext
implements KubernetesResource {
    @JsonProperty(value="fsGroup")
    @JsonPropertyDescription(value="A special supplemental group that applies to all containers in a pod.\nSome volume types allow the Kubelet to change the ownership of that volume\nto be owned by the pod:\n\n\n1. The owning GID will be the FSGroup\n2. The setgid bit is set (new files created in the volume will be owned by FSGroup)\n3. The permission bits are OR'd with rw-rw----\n\n\nIf unset, the Kubelet will not modify the ownership and permissions of any volume.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long fsGroup;
    @JsonProperty(value="fsGroupChangePolicy")
    @JsonPropertyDescription(value="fsGroupChangePolicy defines behavior of changing ownership and permission of the volume\nbefore being exposed inside Pod. This field will only apply to\nvolume types which support fsGroup based ownership(and permissions).\nIt will have no effect on ephemeral volume types such as: secret, configmaps\nand emptydir.\nValid values are \"OnRootMismatch\" and \"Always\". If not specified, \"Always\" is used.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String fsGroupChangePolicy;
    @JsonProperty(value="runAsGroup")
    @JsonPropertyDescription(value="The GID to run the entrypoint of the container process.\nUses runtime default if unset.\nMay also be set in SecurityContext.  If set in both SecurityContext and\nPodSecurityContext, the value specified in SecurityContext takes precedence\nfor that container.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long runAsGroup;
    @JsonProperty(value="runAsNonRoot")
    @JsonPropertyDescription(value="Indicates that the container must run as a non-root user.\nIf true, the Kubelet will validate the image at runtime to ensure that it\ndoes not run as UID 0 (root) and fail to start the container if it does.\nIf unset or false, no such validation will be performed.\nMay also be set in SecurityContext.  If set in both SecurityContext and\nPodSecurityContext, the value specified in SecurityContext takes precedence.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean runAsNonRoot;
    @JsonProperty(value="runAsUser")
    @JsonPropertyDescription(value="The UID to run the entrypoint of the container process.\nDefaults to user specified in image metadata if unspecified.\nMay also be set in SecurityContext.  If set in both SecurityContext and\nPodSecurityContext, the value specified in SecurityContext takes precedence\nfor that container.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long runAsUser;
    @JsonProperty(value="seLinuxOptions")
    @JsonPropertyDescription(value="The SELinux context to be applied to all containers.\nIf unspecified, the container runtime will allocate a random SELinux context for each\ncontainer.  May also be set in SecurityContext.  If set in\nboth SecurityContext and PodSecurityContext, the value specified in SecurityContext\ntakes precedence for that container.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SeLinuxOptions seLinuxOptions;
    @JsonProperty(value="seccompProfile")
    @JsonPropertyDescription(value="The seccomp options to use by the containers in this pod.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SeccompProfile seccompProfile;
    @JsonProperty(value="supplementalGroups")
    @JsonPropertyDescription(value="A list of groups applied to the first process run in each container, in addition\nto the container's primary GID, the fsGroup (if specified), and group memberships\ndefined in the container image for the uid of the container process. If unspecified,\nno additional groups are added to any container. Note that group memberships\ndefined in the container image for the uid of the container process are still effective,\neven if they are not included in this list.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Long> supplementalGroups;
    @JsonProperty(value="sysctls")
    @JsonPropertyDescription(value="Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported\nsysctls (by the container runtime) might fail to launch.\nNote that this field cannot be set when spec.os.name is windows.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Sysctls> sysctls;
    @JsonProperty(value="windowsOptions")
    @JsonPropertyDescription(value="The Windows specific settings applied to all containers.\nIf unspecified, the options within a container's SecurityContext will be used.\nIf set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.\nNote that this field cannot be set when spec.os.name is linux.")
    @JsonSetter(nulls=Nulls.SKIP)
    private WindowsOptions windowsOptions;

    public Long getFsGroup() {
        return this.fsGroup;
    }

    public void setFsGroup(Long fsGroup) {
        this.fsGroup = fsGroup;
    }

    public String getFsGroupChangePolicy() {
        return this.fsGroupChangePolicy;
    }

    public void setFsGroupChangePolicy(String fsGroupChangePolicy) {
        this.fsGroupChangePolicy = fsGroupChangePolicy;
    }

    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    public void setRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public void setRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public void setRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
    }

    public SeLinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions;
    }

    public void setSeLinuxOptions(SeLinuxOptions seLinuxOptions) {
        this.seLinuxOptions = seLinuxOptions;
    }

    public SeccompProfile getSeccompProfile() {
        return this.seccompProfile;
    }

    public void setSeccompProfile(SeccompProfile seccompProfile) {
        this.seccompProfile = seccompProfile;
    }

    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public void setSupplementalGroups(List<Long> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
    }

    public List<Sysctls> getSysctls() {
        return this.sysctls;
    }

    public void setSysctls(List<Sysctls> sysctls) {
        this.sysctls = sysctls;
    }

    public WindowsOptions getWindowsOptions() {
        return this.windowsOptions;
    }

    public void setWindowsOptions(WindowsOptions windowsOptions) {
        this.windowsOptions = windowsOptions;
    }
}

