/*
 * Decompiled with CFR 0.152.
 */
package dev.strela.v1.minecraftserverspec.template.spec.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import dev.strela.v1.minecraftserverspec.template.spec.volumes.rbd.SecretRef;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"fsType", "image", "keyring", "monitors", "pool", "readOnly", "secretRef", "user"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Rbd
implements KubernetesResource {
    @JsonProperty(value="fsType")
    @JsonPropertyDescription(value="fsType is the filesystem type of the volume that you want to mount.\nTip: Ensure that the filesystem type is supported by the host operating system.\nExamples: \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.\nMore info: https://kubernetes.io/docs/concepts/storage/volumes#rbd\nTODO: how do we prevent errors in the filesystem from compromising the machine")
    @JsonSetter(nulls=Nulls.SKIP)
    private String fsType;
    @JsonProperty(value="image")
    @Required
    @JsonPropertyDescription(value="image is the rados image name.\nMore info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="keyring")
    @JsonPropertyDescription(value="keyring is the path to key ring for RBDUser.\nDefault is /etc/ceph/keyring.\nMore info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonSetter(nulls=Nulls.SKIP)
    private String keyring;
    @JsonProperty(value="monitors")
    @Required
    @JsonPropertyDescription(value="monitors is a collection of Ceph monitors.\nMore info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> monitors;
    @JsonProperty(value="pool")
    @JsonPropertyDescription(value="pool is the rados pool name.\nDefault is rbd.\nMore info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonSetter(nulls=Nulls.SKIP)
    private String pool;
    @JsonProperty(value="readOnly")
    @JsonPropertyDescription(value="readOnly here will force the ReadOnly setting in VolumeMounts.\nDefaults to false.\nMore info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean readOnly;
    @JsonProperty(value="secretRef")
    @JsonPropertyDescription(value="secretRef is name of the authentication secret for RBDUser. If provided\noverrides keyring.\nDefault is nil.\nMore info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonSetter(nulls=Nulls.SKIP)
    private SecretRef secretRef;
    @JsonProperty(value="user")
    @JsonPropertyDescription(value="user is the rados user name.\nDefault is admin.\nMore info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it")
    @JsonSetter(nulls=Nulls.SKIP)
    private String user;

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getKeyring() {
        return this.keyring;
    }

    public void setKeyring(String keyring) {
        this.keyring = keyring;
    }

    public List<String> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<String> monitors) {
        this.monitors = monitors;
    }

    public String getPool() {
        return this.pool;
    }

    public void setPool(String pool) {
        this.pool = pool;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public SecretRef getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(SecretRef secretRef) {
        this.secretRef = secretRef;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

