/*
 * Decompiled with CFR 0.152.
 */
package dev.strela.v1.minecraftserversetspec.template.spec.template.spec.ephemeralcontainers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import dev.strela.v1.minecraftserversetspec.template.spec.template.spec.ephemeralcontainers.lifecycle.PostStart;
import dev.strela.v1.minecraftserversetspec.template.spec.template.spec.ephemeralcontainers.lifecycle.PreStop;
import io.fabric8.kubernetes.api.model.KubernetesResource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"postStart", "preStop"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Lifecycle
implements KubernetesResource {
    @JsonProperty(value="postStart")
    @JsonPropertyDescription(value="PostStart is called immediately after a container is created. If the handler fails,\nthe container is terminated and restarted according to its restart policy.\nOther management of the container blocks until the hook completes.\nMore info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks")
    @JsonSetter(nulls=Nulls.SKIP)
    private PostStart postStart;
    @JsonProperty(value="preStop")
    @JsonPropertyDescription(value="PreStop is called immediately before a container is terminated due to an\nAPI request or management event such as liveness/startup probe failure,\npreemption, resource contention, etc. The handler is not called if the\ncontainer crashes or exits. The Pod's termination grace period countdown begins before the\nPreStop hook is executed. Regardless of the outcome of the handler, the\ncontainer will eventually terminate within the Pod's termination grace\nperiod (unless delayed by finalizers). Other management of the container blocks until the hook completes\nor until the termination grace period is reached.\nMore info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks")
    @JsonSetter(nulls=Nulls.SKIP)
    private PreStop preStop;

    public PostStart getPostStart() {
        return this.postStart;
    }

    public void setPostStart(PostStart postStart) {
        this.postStart = postStart;
    }

    public PreStop getPreStop() {
        return this.preStop;
    }

    public void setPreStop(PreStop preStop) {
        this.preStop = preStop;
    }
}

