/*
 * Decompiled with CFR 0.152.
 */
package dev.strela.v1;

import dev.strela.v1.MinecraftDeployments;
import dev.strela.v1.MinecraftServer;
import dev.strela.v1.MinecraftServerSets;
import dev.strela.v1.MinecraftServers;
import dev.strela.v1.MinecraftStatefulSets;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import java.util.concurrent.CompletableFuture;

public class StrelaSdk {
    private static final String DEFAULT_NAMESPACE = "strela-system";
    private static final String POD_NAME_ENV = "POD_NAME";
    private final MinecraftDeployments minecraftDeployments;
    private final MinecraftStatefulSets minecraftStatefulSets;
    private final MinecraftServerSets minecraftServerSets;
    private final MinecraftServers minecraftServers;
    private final String currentPodName;

    private StrelaSdk(KubernetesClient kubernetesClient, String defaultNamespace) {
        this.minecraftDeployments = new MinecraftDeployments(kubernetesClient, defaultNamespace);
        this.minecraftStatefulSets = new MinecraftStatefulSets(kubernetesClient, defaultNamespace);
        this.minecraftServerSets = new MinecraftServerSets(kubernetesClient, defaultNamespace);
        this.minecraftServers = new MinecraftServers(kubernetesClient, defaultNamespace);
        this.currentPodName = System.getenv(POD_NAME_ENV);
    }

    public MinecraftDeployments minecraftDeployments() {
        return this.minecraftDeployments;
    }

    public MinecraftStatefulSets minecraftStatefulSets() {
        return this.minecraftStatefulSets;
    }

    public MinecraftServerSets minecraftServerSets() {
        return this.minecraftServerSets;
    }

    public MinecraftServers minecraftServers() {
        return this.minecraftServers;
    }

    public String getCurrentMinecraftServerName() {
        if (this.currentPodName == null) {
            throw new IllegalStateException("The SDK is not running in a Kubernetes pod. The current pod name is not available.");
        }
        return this.currentPodName;
    }

    public CompletableFuture<MinecraftServer> getCurrentMinecraftServer() {
        return this.minecraftServers.get(this.getCurrentMinecraftServerName());
    }

    public static StrelaSdk create(KubernetesClient kubernetesClient, String defaultNamespace) {
        return new StrelaSdk(kubernetesClient, defaultNamespace);
    }

    public static StrelaSdk create(String defaultNamespace) {
        return new StrelaSdk(new KubernetesClientBuilder().build(), defaultNamespace);
    }

    public static StrelaSdk create() {
        return new StrelaSdk(new KubernetesClientBuilder().build(), DEFAULT_NAMESPACE);
    }
}

