/*
 * Decompiled with CFR 0.152.
 */
package dev.strela.v1;

import dev.strela.v1.KubernetesCrudRepository;
import dev.strela.v1.MinecraftServer;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.util.concurrent.CompletableFuture;

public class MinecraftServers
extends KubernetesCrudRepository<MinecraftServer> {
    public MinecraftServers(KubernetesClient kubernetesClient, String defaultNamespace) {
        super(MinecraftServer.class, kubernetesClient, defaultNamespace);
    }

    public CompletableFuture<Pod> getPodByMinecraftServer(MinecraftServer server) {
        return this.getPodByMinecraftServer(this.defaultNamespace, server);
    }

    public CompletableFuture<Pod> getPodByMinecraftServer(String namespace, MinecraftServer server) {
        return CompletableFuture.supplyAsync(() -> (Pod)((PodResource)((NonNamespaceOperation)this.kubernetesClient.pods().inNamespace(namespace)).withName(server.getMetadata().getName())).get());
    }
}

