/*
 * Decompiled with CFR 0.152.
 */
package dev.strela.v1;

import dev.strela.v1.ConsumerUtil;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class KubernetesCrudRepository<R extends CustomResource> {
    protected final Class<R> customResourceClass;
    protected final KubernetesClient kubernetesClient;
    protected final String defaultNamespace;

    protected KubernetesCrudRepository(Class<R> customResourceClass, KubernetesClient kubernetesClient, String defaultNamespace) {
        this.customResourceClass = customResourceClass;
        this.kubernetesClient = kubernetesClient;
        this.defaultNamespace = defaultNamespace;
    }

    public CompletableFuture<R> create(R resource) {
        return this.create(this.defaultNamespace, resource);
    }

    public CompletableFuture<R> create(String namespace, R resource) {
        return CompletableFuture.supplyAsync(() -> {
            this.kubernetesClient.resource((HasMetadata)resource).inNamespace(namespace).create();
            return resource;
        });
    }

    public CompletableFuture<R> update(R resource) {
        return this.update(this.defaultNamespace, resource);
    }

    public CompletableFuture<R> update(String namespace, R resource) {
        return CompletableFuture.supplyAsync(() -> {
            this.kubernetesClient.resource((HasMetadata)resource).inNamespace(namespace).unlock().createOr(Updatable::update);
            return resource;
        });
    }

    public CompletableFuture<R> update(String name, Consumer<R> updater) {
        return this.update(this.defaultNamespace, name, updater);
    }

    public CompletableFuture<R> update(String namespace, String name, Consumer<R> updater) {
        return this.get(namespace, name).thenApplyAsync(resource -> {
            updater.accept(resource);
            return this.update(namespace, resource).join();
        });
    }

    public CompletableFuture<R> get(String name) {
        return this.get(this.defaultNamespace, name);
    }

    public CompletableFuture<R> get(String namespace, String name) {
        return CompletableFuture.supplyAsync(() -> (CustomResource)((Resource)((NonNamespaceOperation)this.kubernetesClient.resources(this.customResourceClass).inNamespace(namespace)).withName(name)).get());
    }

    public CompletableFuture<List<R>> list() {
        return this.list(this.defaultNamespace);
    }

    public CompletableFuture<List<R>> list(String namespace) {
        return CompletableFuture.supplyAsync(() -> ((KubernetesResourceList)((NonNamespaceOperation)this.kubernetesClient.resources(this.customResourceClass).inNamespace(namespace)).list()).getItems());
    }

    public CompletableFuture<Void> delete(String name) {
        return this.delete(this.defaultNamespace, name);
    }

    public CompletableFuture<Void> delete(String namespace, String name) {
        return CompletableFuture.runAsync(() -> ((Resource)((NonNamespaceOperation)this.kubernetesClient.resources(this.customResourceClass).inNamespace(namespace)).withName(name)).delete());
    }

    public CrudResourceInformerBuilder createInformer() {
        return this.createInformer(this.defaultNamespace);
    }

    public CrudResourceInformerBuilder createInformer(String namespace) {
        return new CrudResourceInformerBuilder(namespace);
    }

    public class CrudResourceInformerBuilder {
        private final String namespace;
        private Consumer<R> addHandler = ConsumerUtil.empty();
        private BiConsumer<R, R> updateHandler = ConsumerUtil.emptyBi();
        private Consumer<R> deleteHandler = ConsumerUtil.empty();

        public CrudResourceInformerBuilder(String namespace) {
            this.namespace = namespace;
        }

        public CrudResourceInformerBuilder withAddHandler(Consumer<R> onAdd) {
            this.addHandler = onAdd;
            return this;
        }

        public CrudResourceInformerBuilder withUpdateHandler(BiConsumer<R, R> onUpdate) {
            this.updateHandler = onUpdate;
            return this;
        }

        public CrudResourceInformerBuilder withDeleteHandler(Consumer<R> onDelete) {
            this.deleteHandler = onDelete;
            return this;
        }

        public void inform() {
            CompletableFuture.runAsync(() -> ((NonNamespaceOperation)KubernetesCrudRepository.this.kubernetesClient.resources(KubernetesCrudRepository.this.customResourceClass).inNamespace(this.namespace)).inform(new ResourceEventHandler<R>(){

                public void onAdd(R obj) {
                    CrudResourceInformerBuilder.this.addHandler.accept(obj);
                }

                public void onUpdate(R oldObj, R newObj) {
                    CrudResourceInformerBuilder.this.updateHandler.accept(oldObj, newObj);
                }

                public void onDelete(R obj, boolean deletedFinalStateUnknown) {
                    CrudResourceInformerBuilder.this.deleteHandler.accept(obj);
                }
            }));
        }
    }
}

