package dev.strela.v1.minecraftstatefulsetspec.template.spec.template.spec;

@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@com.fasterxml.jackson.annotation.JsonPropertyOrder({"labelSelector","matchLabelKeys","maxSkew","minDomains","nodeAffinityPolicy","nodeTaintsPolicy","topologyKey","whenUnsatisfiable"})
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@javax.annotation.processing.Generated("io.fabric8.java.generator.CRGeneratorRunner")
public class TopologySpreadConstraints implements io.fabric8.kubernetes.api.model.KubernetesResource {

    /**
     * LabelSelector is used to find matching pods.
     * Pods that match this label selector are counted to determine the number of pods
     * in their corresponding topology domain.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("labelSelector")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("LabelSelector is used to find matching pods.\nPods that match this label selector are counted to determine the number of pods\nin their corresponding topology domain.")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private dev.strela.v1.minecraftstatefulsetspec.template.spec.template.spec.topologyspreadconstraints.LabelSelector labelSelector;

    public dev.strela.v1.minecraftstatefulsetspec.template.spec.template.spec.topologyspreadconstraints.LabelSelector getLabelSelector() {
        return labelSelector;
    }

    public void setLabelSelector(dev.strela.v1.minecraftstatefulsetspec.template.spec.template.spec.topologyspreadconstraints.LabelSelector labelSelector) {
        this.labelSelector = labelSelector;
    }

    /**
     * MatchLabelKeys is a set of pod label keys to select the pods over which
     * spreading will be calculated. The keys are used to lookup values from the
     * incoming pod labels, those key-value labels are ANDed with labelSelector
     * to select the group of existing pods over which spreading will be calculated
     * for the incoming pod. The same key is forbidden to exist in both MatchLabelKeys and LabelSelector.
     * MatchLabelKeys cannot be set when LabelSelector isn't set.
     * Keys that don't exist in the incoming pod labels will
     * be ignored. A null or empty list means only match against labelSelector.
     *
     * This is a beta field and requires the MatchLabelKeysInPodTopologySpread feature gate to be enabled (enabled by default).
     */
    @com.fasterxml.jackson.annotation.JsonProperty("matchLabelKeys")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("MatchLabelKeys is a set of pod label keys to select the pods over which\nspreading will be calculated. The keys are used to lookup values from the\nincoming pod labels, those key-value labels are ANDed with labelSelector\nto select the group of existing pods over which spreading will be calculated\nfor the incoming pod. The same key is forbidden to exist in both MatchLabelKeys and LabelSelector.\nMatchLabelKeys cannot be set when LabelSelector isn't set.\nKeys that don't exist in the incoming pod labels will\nbe ignored. A null or empty list means only match against labelSelector.\n\n\nThis is a beta field and requires the MatchLabelKeysInPodTopologySpread feature gate to be enabled (enabled by default).")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private java.util.List<String> matchLabelKeys;

    public java.util.List<String> getMatchLabelKeys() {
        return matchLabelKeys;
    }

    public void setMatchLabelKeys(java.util.List<String> matchLabelKeys) {
        this.matchLabelKeys = matchLabelKeys;
    }

    /**
     * MaxSkew describes the degree to which pods may be unevenly distributed.
     * When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference
     * between the number of matching pods in the target topology and the global minimum.
     * The global minimum is the minimum number of matching pods in an eligible domain
     * or zero if the number of eligible domains is less than MinDomains.
     * For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same
     * labelSelector spread as 2/2/1:
     * In this case, the global minimum is 1.
     * | zone1 | zone2 | zone3 |
     * |  P P  |  P P  |   P   |
     * - if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 2/2/2;
     * scheduling it onto zone1(zone2) would make the ActualSkew(3-1) on zone1(zone2)
     * violate MaxSkew(1).
     * - if MaxSkew is 2, incoming pod can be scheduled onto any zone.
     * When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence
     * to topologies that satisfy it.
     * It's a required field. Default value is 1 and 0 is not allowed.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("maxSkew")
    @io.fabric8.generator.annotation.Required()
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("MaxSkew describes the degree to which pods may be unevenly distributed.\nWhen `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference\nbetween the number of matching pods in the target topology and the global minimum.\nThe global minimum is the minimum number of matching pods in an eligible domain\nor zero if the number of eligible domains is less than MinDomains.\nFor example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same\nlabelSelector spread as 2/2/1:\nIn this case, the global minimum is 1.\n| zone1 | zone2 | zone3 |\n|  P P  |  P P  |   P   |\n- if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 2/2/2;\nscheduling it onto zone1(zone2) would make the ActualSkew(3-1) on zone1(zone2)\nviolate MaxSkew(1).\n- if MaxSkew is 2, incoming pod can be scheduled onto any zone.\nWhen `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence\nto topologies that satisfy it.\nIt's a required field. Default value is 1 and 0 is not allowed.")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private Integer maxSkew;

    public Integer getMaxSkew() {
        return maxSkew;
    }

    public void setMaxSkew(Integer maxSkew) {
        this.maxSkew = maxSkew;
    }

    /**
     * MinDomains indicates a minimum number of eligible domains.
     * When the number of eligible domains with matching topology keys is less than minDomains,
     * Pod Topology Spread treats "global minimum" as 0, and then the calculation of Skew is performed.
     * And when the number of eligible domains with matching topology keys equals or greater than minDomains,
     * this value has no effect on scheduling.
     * As a result, when the number of eligible domains is less than minDomains,
     * scheduler won't schedule more than maxSkew Pods to those domains.
     * If value is nil, the constraint behaves as if MinDomains is equal to 1.
     * Valid values are integers greater than 0.
     * When value is not nil, WhenUnsatisfiable must be DoNotSchedule.
     *
     * For example, in a 3-zone cluster, MaxSkew is set to 2, MinDomains is set to 5 and pods with the same
     * labelSelector spread as 2/2/2:
     * | zone1 | zone2 | zone3 |
     * |  P P  |  P P  |  P P  |
     * The number of domains is less than 5(MinDomains), so "global minimum" is treated as 0.
     * In this situation, new pod with the same labelSelector cannot be scheduled,
     * because computed skew will be 3(3 - 0) if new Pod is scheduled to any of the three zones,
     * it will violate MaxSkew.
     *
     * This is a beta field and requires the MinDomainsInPodTopologySpread feature gate to be enabled (enabled by default).
     */
    @com.fasterxml.jackson.annotation.JsonProperty("minDomains")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("MinDomains indicates a minimum number of eligible domains.\nWhen the number of eligible domains with matching topology keys is less than minDomains,\nPod Topology Spread treats \"global minimum\" as 0, and then the calculation of Skew is performed.\nAnd when the number of eligible domains with matching topology keys equals or greater than minDomains,\nthis value has no effect on scheduling.\nAs a result, when the number of eligible domains is less than minDomains,\nscheduler won't schedule more than maxSkew Pods to those domains.\nIf value is nil, the constraint behaves as if MinDomains is equal to 1.\nValid values are integers greater than 0.\nWhen value is not nil, WhenUnsatisfiable must be DoNotSchedule.\n\n\nFor example, in a 3-zone cluster, MaxSkew is set to 2, MinDomains is set to 5 and pods with the same\nlabelSelector spread as 2/2/2:\n| zone1 | zone2 | zone3 |\n|  P P  |  P P  |  P P  |\nThe number of domains is less than 5(MinDomains), so \"global minimum\" is treated as 0.\nIn this situation, new pod with the same labelSelector cannot be scheduled,\nbecause computed skew will be 3(3 - 0) if new Pod is scheduled to any of the three zones,\nit will violate MaxSkew.\n\n\nThis is a beta field and requires the MinDomainsInPodTopologySpread feature gate to be enabled (enabled by default).")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private Integer minDomains;

    public Integer getMinDomains() {
        return minDomains;
    }

    public void setMinDomains(Integer minDomains) {
        this.minDomains = minDomains;
    }

    /**
     * NodeAffinityPolicy indicates how we will treat Pod's nodeAffinity/nodeSelector
     * when calculating pod topology spread skew. Options are:
     * - Honor: only nodes matching nodeAffinity/nodeSelector are included in the calculations.
     * - Ignore: nodeAffinity/nodeSelector are ignored. All nodes are included in the calculations.
     *
     * If this value is nil, the behavior is equivalent to the Honor policy.
     * This is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("nodeAffinityPolicy")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("NodeAffinityPolicy indicates how we will treat Pod's nodeAffinity/nodeSelector\nwhen calculating pod topology spread skew. Options are:\n- Honor: only nodes matching nodeAffinity/nodeSelector are included in the calculations.\n- Ignore: nodeAffinity/nodeSelector are ignored. All nodes are included in the calculations.\n\n\nIf this value is nil, the behavior is equivalent to the Honor policy.\nThis is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private String nodeAffinityPolicy;

    public String getNodeAffinityPolicy() {
        return nodeAffinityPolicy;
    }

    public void setNodeAffinityPolicy(String nodeAffinityPolicy) {
        this.nodeAffinityPolicy = nodeAffinityPolicy;
    }

    /**
     * NodeTaintsPolicy indicates how we will treat node taints when calculating
     * pod topology spread skew. Options are:
     * - Honor: nodes without taints, along with tainted nodes for which the incoming pod
     * has a toleration, are included.
     * - Ignore: node taints are ignored. All nodes are included.
     *
     * If this value is nil, the behavior is equivalent to the Ignore policy.
     * This is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("nodeTaintsPolicy")
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("NodeTaintsPolicy indicates how we will treat node taints when calculating\npod topology spread skew. Options are:\n- Honor: nodes without taints, along with tainted nodes for which the incoming pod\nhas a toleration, are included.\n- Ignore: node taints are ignored. All nodes are included.\n\n\nIf this value is nil, the behavior is equivalent to the Ignore policy.\nThis is a beta-level feature default enabled by the NodeInclusionPolicyInPodTopologySpread feature flag.")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private String nodeTaintsPolicy;

    public String getNodeTaintsPolicy() {
        return nodeTaintsPolicy;
    }

    public void setNodeTaintsPolicy(String nodeTaintsPolicy) {
        this.nodeTaintsPolicy = nodeTaintsPolicy;
    }

    /**
     * TopologyKey is the key of node labels. Nodes that have a label with this key
     * and identical values are considered to be in the same topology.
     * We consider each <key, value> as a "bucket", and try to put balanced number
     * of pods into each bucket.
     * We define a domain as a particular instance of a topology.
     * Also, we define an eligible domain as a domain whose nodes meet the requirements of
     * nodeAffinityPolicy and nodeTaintsPolicy.
     * e.g. If TopologyKey is "kubernetes.io/hostname", each Node is a domain of that topology.
     * And, if TopologyKey is "topology.kubernetes.io/zone", each zone is a domain of that topology.
     * It's a required field.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("topologyKey")
    @io.fabric8.generator.annotation.Required()
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("TopologyKey is the key of node labels. Nodes that have a label with this key\nand identical values are considered to be in the same topology.\nWe consider each <key, value> as a \"bucket\", and try to put balanced number\nof pods into each bucket.\nWe define a domain as a particular instance of a topology.\nAlso, we define an eligible domain as a domain whose nodes meet the requirements of\nnodeAffinityPolicy and nodeTaintsPolicy.\ne.g. If TopologyKey is \"kubernetes.io/hostname\", each Node is a domain of that topology.\nAnd, if TopologyKey is \"topology.kubernetes.io/zone\", each zone is a domain of that topology.\nIt's a required field.")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private String topologyKey;

    public String getTopologyKey() {
        return topologyKey;
    }

    public void setTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
    }

    /**
     * WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy
     * the spread constraint.
     * - DoNotSchedule (default) tells the scheduler not to schedule it.
     * - ScheduleAnyway tells the scheduler to schedule the pod in any location,
     *   but giving higher precedence to topologies that would help reduce the
     *   skew.
     * A constraint is considered "Unsatisfiable" for an incoming pod
     * if and only if every possible node assignment for that pod would violate
     * "MaxSkew" on some topology.
     * For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same
     * labelSelector spread as 3/1/1:
     * | zone1 | zone2 | zone3 |
     * | P P P |   P   |   P   |
     * If WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled
     * to zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies
     * MaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler
     * won't make it *more* imbalanced.
     * It's a required field.
     */
    @com.fasterxml.jackson.annotation.JsonProperty("whenUnsatisfiable")
    @io.fabric8.generator.annotation.Required()
    @com.fasterxml.jackson.annotation.JsonPropertyDescription("WhenUnsatisfiable indicates how to deal with a pod if it doesn't satisfy\nthe spread constraint.\n- DoNotSchedule (default) tells the scheduler not to schedule it.\n- ScheduleAnyway tells the scheduler to schedule the pod in any location,\n  but giving higher precedence to topologies that would help reduce the\n  skew.\nA constraint is considered \"Unsatisfiable\" for an incoming pod\nif and only if every possible node assignment for that pod would violate\n\"MaxSkew\" on some topology.\nFor example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same\nlabelSelector spread as 3/1/1:\n| zone1 | zone2 | zone3 |\n| P P P |   P   |   P   |\nIf WhenUnsatisfiable is set to DoNotSchedule, incoming pod can only be scheduled\nto zone2(zone3) to become 3/2/1(3/1/2) as ActualSkew(2-1) on zone2(zone3) satisfies\nMaxSkew(1). In other words, the cluster can still be imbalanced, but scheduler\nwon't make it *more* imbalanced.\nIt's a required field.")
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SKIP)
    private String whenUnsatisfiable;

    public String getWhenUnsatisfiable() {
        return whenUnsatisfiable;
    }

    public void setWhenUnsatisfiable(String whenUnsatisfiable) {
        this.whenUnsatisfiable = whenUnsatisfiable;
    }
}

