/*
 * Decompiled with CFR 0.152.
 */
package dev.strela.v1.minecraftdeploymentspec.template.spec.template.spec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"effect", "key", "operator", "tolerationSeconds", "value"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Tolerations
implements KubernetesResource {
    @JsonProperty(value="effect")
    @JsonPropertyDescription(value="Effect indicates the taint effect to match. Empty means match all taint effects.\nWhen specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String effect;
    @JsonProperty(value="key")
    @JsonPropertyDescription(value="Key is the taint key that the toleration applies to. Empty means match all taint keys.\nIf the key is empty, operator must be Exists; this combination means to match all values and all keys.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String key;
    @JsonProperty(value="operator")
    @JsonPropertyDescription(value="Operator represents a key's relationship to the value.\nValid operators are Exists and Equal. Defaults to Equal.\nExists is equivalent to wildcard for value, so that a pod can\ntolerate all taints of a particular category.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String operator;
    @JsonProperty(value="tolerationSeconds")
    @JsonPropertyDescription(value="TolerationSeconds represents the period of time the toleration (which must be\nof effect NoExecute, otherwise this field is ignored) tolerates the taint. By default,\nit is not set, which means tolerate the taint forever (do not evict). Zero and\nnegative values will be treated as 0 (evict immediately) by the system.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long tolerationSeconds;
    @JsonProperty(value="value")
    @JsonPropertyDescription(value="Value is the taint value the toleration matches to.\nIf the operator is Exists, the value should be empty, otherwise just a regular string.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String value;

    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Long getTolerationSeconds() {
        return this.tolerationSeconds;
    }

    public void setTolerationSeconds(Long tolerationSeconds) {
        this.tolerationSeconds = tolerationSeconds;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

