/*
 * Decompiled with CFR 0.152.
 */
package dev.strela.v1;

import dev.strela.v1.KubernetesCrudRepository;
import dev.strela.v1.MinecraftDeployment;
import dev.strela.v1.MinecraftDeploymentSpec;
import dev.strela.v1.MinecraftDeploymentType;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class MinecraftDeployments
extends KubernetesCrudRepository<MinecraftDeployment> {
    public MinecraftDeployments(KubernetesClient kubernetesClient, String defaultNamespace) {
        super(MinecraftDeployment.class, kubernetesClient, defaultNamespace);
    }

    public CompletableFuture<List<MinecraftDeployment>> list(String defaultNamespace, MinecraftDeploymentType type) {
        return CompletableFuture.supplyAsync(() -> ((KubernetesResourceList)((NonNamespaceOperation)this.kubernetesClient.resources(this.customResourceClass).inNamespace(defaultNamespace)).list()).getItems().stream().filter(minecraftDeployment -> ((MinecraftDeploymentSpec)minecraftDeployment.getSpec()).getType().equals(type.toString())).toList());
    }

    public CompletableFuture<List<MinecraftDeployment>> list(MinecraftDeploymentType type) {
        return this.list(this.defaultNamespace, type);
    }

    public CompletableFuture<List<MinecraftDeployment>> listProxies(String defaultNamespace) {
        return this.list(defaultNamespace, MinecraftDeploymentType.PROXY);
    }

    public CompletableFuture<List<MinecraftDeployment>> listProxies() {
        return this.listProxies(this.defaultNamespace);
    }

    public CompletableFuture<List<MinecraftDeployment>> listServers(String defaultNamespace) {
        return this.list(defaultNamespace, MinecraftDeploymentType.SERVER);
    }

    public CompletableFuture<List<MinecraftDeployment>> listServers() {
        return this.listServers(this.defaultNamespace);
    }
}

