package dev.strela.v1;

public class Test {

  public static void main(String[] args) {
    var strelaSdk = StrelaSdk.create();
    strelaSdk.minecraftDeployments().list().thenAccept(minecraftDeployments -> {
      System.out.println(minecraftDeployments.size());
    });

    strelaSdk.minecraftDeployments().update("test", minecraftDeployment -> {
      minecraftDeployment.getSpec().setReplicas(2L);
    });

    strelaSdk.minecraftDeployments().delete("test");

    strelaSdk.minecraftDeployments().create(new dev.strela.v1.MinecraftDeployment());

    strelaSdk.minecraftDeployments().get("test").thenAccept(minecraftDeployment -> {
      System.out.println(minecraftDeployment.getMetadata().getName());
    });
  }

}
