/*
 * Decompiled with CFR 0.152.
 */
package dev.strela.v1.minecraftserverspec.template.spec.ephemeralcontainers;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.model.KubernetesResource;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"containerPort", "hostIP", "hostPort", "name", "protocol"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Ports
implements KubernetesResource {
    @JsonProperty(value="containerPort")
    @Required
    @JsonPropertyDescription(value="Number of port to expose on the pod's IP address.\nThis must be a valid port number, 0 < x < 65536.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer containerPort;
    @JsonProperty(value="hostIP")
    @JsonPropertyDescription(value="What host IP to bind the external port to.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String hostIP;
    @JsonProperty(value="hostPort")
    @JsonPropertyDescription(value="Number of port to expose on the host.\nIf specified, this must be a valid port number, 0 < x < 65536.\nIf HostNetwork is specified, this must match ContainerPort.\nMost containers do not need this.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer hostPort;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="If specified, this must be an IANA_SVC_NAME and unique within the pod. Each\nnamed port in a pod must have a unique name. Name for the port that can be\nreferred to by services.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String name;
    @JsonProperty(value="protocol")
    @JsonPropertyDescription(value="Protocol for port. Must be UDP, TCP, or SCTP.\nDefaults to \"TCP\".")
    @JsonSetter(nulls=Nulls.SKIP)
    private String protocol = "TCP";

    public Integer getContainerPort() {
        return this.containerPort;
    }

    public void setContainerPort(Integer containerPort) {
        this.containerPort = containerPort;
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public void setHostIP(String hostIP) {
        this.hostIP = hostIP;
    }

    public Integer getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(Integer hostPort) {
        this.hostPort = hostPort;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

