/*
 * Decompiled with CFR 0.152.
 */
package dev.strela.v1;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Updatable;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public abstract class KubernetesCrudRepository<R extends CustomResource> {
    protected final Class<R> customResourceClass;
    protected final KubernetesClient kubernetesClient;
    protected final String defaultNamespace;

    protected KubernetesCrudRepository(Class<R> customResourceClass, KubernetesClient kubernetesClient, String defaultNamespace) {
        this.customResourceClass = customResourceClass;
        this.kubernetesClient = kubernetesClient;
        this.defaultNamespace = defaultNamespace;
    }

    public CompletableFuture<R> create(R resource) {
        return this.create(this.defaultNamespace, resource);
    }

    public CompletableFuture<R> create(String namespace, R resource) {
        return CompletableFuture.supplyAsync(() -> {
            this.kubernetesClient.resource((HasMetadata)resource).inNamespace(namespace).create();
            return resource;
        });
    }

    public CompletableFuture<R> update(R resource) {
        return this.update(this.defaultNamespace, resource);
    }

    public CompletableFuture<R> update(String namespace, R resource) {
        return CompletableFuture.supplyAsync(() -> {
            this.kubernetesClient.resource((HasMetadata)resource).inNamespace(namespace).unlock().createOr(Updatable::update);
            return resource;
        });
    }

    public CompletableFuture<R> update(String name, Consumer<R> updater) {
        return this.update(this.defaultNamespace, name, updater);
    }

    public CompletableFuture<R> update(String namespace, String name, Consumer<R> updater) {
        return CompletableFuture.supplyAsync(() -> {
            CustomResource resource = (CustomResource)this.get(namespace, name).join();
            updater.accept(resource);
            return this.update(namespace, resource).join();
        });
    }

    public CompletableFuture<R> get(String name) {
        return this.get(this.defaultNamespace, name);
    }

    public CompletableFuture<R> get(String namespace, String name) {
        return CompletableFuture.supplyAsync(() -> (CustomResource)((Resource)((NonNamespaceOperation)this.kubernetesClient.resources(this.customResourceClass).inNamespace(namespace)).withName(name)).get());
    }

    public CompletableFuture<List<R>> list() {
        return this.list(this.defaultNamespace);
    }

    public CompletableFuture<List<R>> list(String namespace) {
        return CompletableFuture.supplyAsync(() -> ((KubernetesResourceList)((NonNamespaceOperation)this.kubernetesClient.resources(this.customResourceClass).inNamespace(namespace)).list()).getItems());
    }

    public CompletableFuture<Void> delete(String name) {
        return this.delete(this.defaultNamespace, name);
    }

    public CompletableFuture<Void> delete(String namespace, String name) {
        return CompletableFuture.runAsync(() -> ((Resource)((NonNamespaceOperation)this.kubernetesClient.resources(this.customResourceClass).inNamespace(namespace)).withName(name)).delete());
    }
}

