/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jackson;

import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.Collection;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.jackson.JsonMixin;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class JsonMixinModule
extends SimpleModule
implements InitializingBean {
    private final ApplicationContext context;
    private final Collection<String> basePackages;

    public JsonMixinModule(ApplicationContext context, Collection<String> basePackages) {
        Assert.notNull((Object)context, "Context must not be null");
        this.context = context;
        this.basePackages = basePackages;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (ObjectUtils.isEmpty(this.basePackages)) {
            return;
        }
        JsonMixinComponentScanner scanner = new JsonMixinComponentScanner();
        scanner.setEnvironment(this.context.getEnvironment());
        scanner.setResourceLoader(this.context);
        for (String basePackage : this.basePackages) {
            if (!StringUtils.hasText(basePackage)) continue;
            for (BeanDefinition candidate : scanner.findCandidateComponents(basePackage)) {
                this.addJsonMixin(ClassUtils.forName(candidate.getBeanClassName(), this.context.getClassLoader()));
            }
        }
    }

    private void addJsonMixin(Class<?> mixinClass) {
        MergedAnnotation<JsonMixin> annotation = MergedAnnotations.from(mixinClass, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).get(JsonMixin.class);
        for (Class<?> targetType : annotation.getClassArray("type")) {
            this.setMixInAnnotation(targetType, mixinClass);
        }
    }

    static class JsonMixinComponentScanner
    extends ClassPathScanningCandidateComponentProvider {
        JsonMixinComponentScanner() {
            this.addIncludeFilter(new AnnotationTypeFilter(JsonMixin.class));
        }

        @Override
        protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
            return true;
        }
    }
}

