/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.util.ClassUtils;

public class ConfigurationPropertiesBindException
extends BeanCreationException {
    private final ConfigurationPropertiesBean bean;

    ConfigurationPropertiesBindException(ConfigurationPropertiesBean bean2, Exception cause) {
        super(bean2.getName(), ConfigurationPropertiesBindException.getMessage(bean2), cause);
        this.bean = bean2;
    }

    public Class<?> getBeanType() {
        return this.bean.getType();
    }

    public ConfigurationProperties getAnnotation() {
        return this.bean.getAnnotation();
    }

    private static String getMessage(ConfigurationPropertiesBean bean2) {
        ConfigurationProperties annotation = bean2.getAnnotation();
        StringBuilder message = new StringBuilder();
        message.append("Could not bind properties to '");
        message.append(ClassUtils.getShortName(bean2.getType())).append("' : ");
        message.append("prefix=").append(annotation.prefix());
        message.append(", ignoreInvalidFields=").append(annotation.ignoreInvalidFields());
        message.append(", ignoreUnknownFields=").append(annotation.ignoreUnknownFields());
        return message.toString();
    }
}

