package dev.speakeasyapi.sdk.utils;

import org.apache.commons.io.output.TeeOutputStream;

import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Locale;

public class SpeakeasyResponseWrapper implements HttpServletResponse {

    public class OutputStreamWrapper extends ServletOutputStream {

        private ServletOutputStream wrapped;
        private ByteArrayOutputStream speakeasyOutputStream;
        private TeeOutputStream teeOutputStream;

        public OutputStreamWrapper(ServletOutputStream wrapped) {
            this.wrapped = wrapped;
            speakeasyOutputStream = new ByteArrayOutputStream();
            teeOutputStream = new TeeOutputStream(wrapped, speakeasyOutputStream);
        }

        public ByteArrayOutputStream getSpeakeasyOutputStream() {
            return speakeasyOutputStream;
        }

        @Override
        public boolean isReady() {
            return wrapped.isReady();
        }

        @Override
        public void setWriteListener(WriteListener listener) {
            wrapped.setWriteListener(listener);
        }

        @Override
        public void write(int b) throws IOException {
            teeOutputStream.write(b);
        }
    }

    private HttpServletResponse wrapped;
    private OutputStreamWrapper outputStreamWrapper;

    public SpeakeasyResponseWrapper(HttpServletResponse wrapped) throws IOException {
        this.wrapped = wrapped;
        this.outputStreamWrapper = new OutputStreamWrapper(wrapped.getOutputStream());
    }

    public ByteArrayOutputStream getSpeakeasyOutputStream() {
        return outputStreamWrapper.getSpeakeasyOutputStream();
    }

    @Override
    public void addCookie(Cookie cookie) {
        wrapped.addCookie(cookie);
    }

    @Override
    public boolean containsHeader(String name) {
        return wrapped.containsHeader(name);
    }

    @Override
    public String encodeURL(String url) {
        return wrapped.encodeURL(url);
    }

    @Override
    public String encodeRedirectURL(String url) {
        return wrapped.encodeRedirectURL(url);
    }

    @Override
    public String encodeUrl(String url) {
        return wrapped.encodeURL(url);
    }

    @Override
    public String encodeRedirectUrl(String url) {
        return wrapped.encodeRedirectUrl(url);
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        wrapped.sendError(sc, msg);
    }

    @Override
    public void sendError(int sc) throws IOException {
        wrapped.sendError(sc);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        wrapped.sendRedirect(location);
    }

    @Override
    public void setDateHeader(String name, long date) {
        wrapped.setDateHeader(name, date);
    }

    @Override
    public void addDateHeader(String name, long date) {
        wrapped.addDateHeader(name, date);
    }

    @Override
    public void setHeader(String name, String value) {
        wrapped.setHeader(name, value);
    }

    @Override
    public void addHeader(String name, String value) {
        wrapped.addHeader(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        wrapped.setIntHeader(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        wrapped.addIntHeader(name, value);
    }

    @Override
    public void setStatus(int sc) {
        wrapped.setStatus(sc);
    }

    @Override
    public void setStatus(int sc, String sm) {
        wrapped.setStatus(sc, sm);
    }

    @Override
    public int getStatus() {
        return wrapped.getStatus();
    }

    @Override
    public String getHeader(String name) {
        return wrapped.getHeader(name);
    }

    @Override
    public Collection<String> getHeaders(String name) {
        return wrapped.getHeaders(name);
    }

    @Override
    public Collection<String> getHeaderNames() {
        return wrapped.getHeaderNames();
    }

    @Override
    public String getCharacterEncoding() {
        return wrapped.getCharacterEncoding();
    }

    @Override
    public String getContentType() {
        return wrapped.getContentType();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return outputStreamWrapper;
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        return wrapped.getWriter();
    }

    @Override
    public void setCharacterEncoding(String charset) {
        wrapped.setCharacterEncoding(charset);
    }

    @Override
    public void setContentLength(int len) {
        wrapped.setContentLength(len);
    }

    @Override
    public void setContentLengthLong(long length) {
        wrapped.setContentLengthLong(length);
    }

    @Override
    public void setContentType(String type) {
        wrapped.setContentType(type);
    }

    @Override
    public void setBufferSize(int size) {
        wrapped.setBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        return wrapped.getBufferSize();
    }

    @Override
    public void flushBuffer() throws IOException {
        wrapped.flushBuffer();
    }

    @Override
    public void resetBuffer() {
        wrapped.resetBuffer();
    }

    @Override
    public boolean isCommitted() {
        return wrapped.isCommitted();
    }

    @Override
    public void reset() {
        wrapped.reset();
    }

    @Override
    public void setLocale(Locale loc) {
        wrapped.setLocale(loc);
    }

    @Override
    public Locale getLocale() {
        return wrapped.getLocale();
    }
}
