/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.sdk.utils;

import dev.speakeasyapi.sdk.SpeakeasyRequestResponseHandler;
import dev.speakeasyapi.sdk.client.SpeakeasyClient;
import dev.speakeasyapi.sdk.utils.SpeakeasyMiddlewareController;
import dev.speakeasyapi.sdk.utils.SpeakeasyRequestWrapper;
import dev.speakeasyapi.sdk.utils.SpeakeasyResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.time.Instant;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class SpeakeasyInterceptor
implements HandlerInterceptor {
    public static final String ControllerKey = "speakeasyMiddlewareController";
    private String serverUrl = "grpc.prod.speakeasyapi.dev:443";
    private boolean secureGrpc = true;
    private Logger logger = LoggerFactory.getLogger(SpeakeasyInterceptor.class);
    private SpeakeasyRequestResponseHandler requestResponseHandler;
    private Instant startTime;
    private String pathHint = "";

    public SpeakeasyInterceptor(String apiKey, String apiID, String versionID) {
        this.init(apiKey, apiID, versionID, this.logger);
    }

    public SpeakeasyInterceptor(String apiKey, String apiID, String versionID, Logger logger) {
        this.init(apiKey, apiID, versionID, logger);
    }

    public SpeakeasyInterceptor(SpeakeasyRequestResponseHandler requestResponseHandler) {
        this.requestResponseHandler = requestResponseHandler;
    }

    private void init(String apiKey, String apiID, String versionID, Logger logger) {
        String serverSecure;
        this.logger = logger;
        String serverURL = System.getenv("SPEAKEASY_SERVER_URL");
        if (serverURL != null) {
            this.serverUrl = serverURL;
        }
        if ("false".equals(serverSecure = System.getenv("SPEAKEASY_SERVER_SECURE"))) {
            this.secureGrpc = false;
        }
        this.requestResponseHandler = new SpeakeasyRequestResponseHandler(new SpeakeasyClient(apiKey, apiID, versionID, this.serverUrl, this.secureGrpc), logger);
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        this.startTime = Instant.now();
        if (handler instanceof HandlerMethod) {
            this.pathHint = this.getPathHint((HandlerMethod)handler);
        }
        request.setAttribute(ControllerKey, new SpeakeasyMiddlewareController());
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest req, HttpServletResponse res, Object handler, Exception ex) {
        SpeakeasyMiddlewareController controller = (SpeakeasyMiddlewareController)req.getAttribute(ControllerKey);
        if (StringUtils.hasText(controller.getPathHint())) {
            this.pathHint = controller.getPathHint();
        }
        new Thread(() -> {
            try {
                ByteArrayOutputStream requestOutputStream = null;
                ByteArrayOutputStream responseOutputStream = null;
                try {
                    responseOutputStream = ((SpeakeasyResponseWrapper)res).getSpeakeasyOutputStream();
                    requestOutputStream = (ByteArrayOutputStream)req.getAttribute(SpeakeasyRequestWrapper.speakeasyOutputStringAttribute);
                }
                catch (Exception e) {
                    this.logger.error("speakeasy-sdk:", e);
                }
                this.requestResponseHandler.captureRequestResponse(req, requestOutputStream, res, responseOutputStream, this.startTime, Instant.now(), this.pathHint, controller.getCustomerID());
            }
            catch (Exception e) {
                this.logger.error("speakeasy-sdk:", e);
            }
        }).start();
    }

    private String getPathHint(HandlerMethod hm) {
        PatchMapping mapping;
        RequestMapping ctrlMapping;
        String controllerPath = "";
        if (hm.getBean().getClass().isAnnotationPresent(RequestMapping.class) && (ctrlMapping = hm.getBean().getClass().getAnnotation(RequestMapping.class)) != null && ctrlMapping.value() != null && ctrlMapping.value().length > 0) {
            controllerPath = ctrlMapping.value()[0];
            if (this.pathHint.endsWith("/")) {
                controllerPath = this.pathHint.substring(0, this.pathHint.length() - 1);
            }
            if (!controllerPath.startsWith("/")) {
                controllerPath = "/" + controllerPath;
            }
        }
        String methodPath = "";
        if (hm.hasMethodAnnotation(RequestMapping.class)) {
            RequestMapping mapping2 = hm.getMethodAnnotation(RequestMapping.class);
            if (mapping2 != null && mapping2.value() != null && mapping2.value().length > 0) {
                methodPath = mapping2.value()[0];
            }
        } else if (hm.hasMethodAnnotation(GetMapping.class)) {
            GetMapping mapping3 = hm.getMethodAnnotation(GetMapping.class);
            if (mapping3 != null && mapping3.value() != null && mapping3.value().length > 0) {
                methodPath = mapping3.value()[0];
            }
        } else if (hm.hasMethodAnnotation(PostMapping.class)) {
            PostMapping mapping4 = hm.getMethodAnnotation(PostMapping.class);
            if (mapping4 != null && mapping4.value() != null && mapping4.value().length > 0) {
                methodPath = mapping4.value()[0];
            }
        } else if (hm.hasMethodAnnotation(PutMapping.class)) {
            PutMapping mapping5 = hm.getMethodAnnotation(PutMapping.class);
            if (mapping5 != null && mapping5.value() != null && mapping5.value().length > 0) {
                methodPath = mapping5.value()[0];
            }
        } else if (hm.hasMethodAnnotation(DeleteMapping.class)) {
            DeleteMapping mapping6 = hm.getMethodAnnotation(DeleteMapping.class);
            if (mapping6 != null && mapping6.value() != null && mapping6.value().length > 0) {
                methodPath = mapping6.value()[0];
            }
        } else if (hm.hasMethodAnnotation(PatchMapping.class) && (mapping = hm.getMethodAnnotation(PatchMapping.class)) != null && mapping.value() != null && mapping.value().length > 0) {
            methodPath = mapping.value()[0];
        }
        if (!methodPath.startsWith("/")) {
            methodPath = "/" + methodPath;
        }
        return controllerPath + methodPath;
    }
}

