/*
 * Decompiled with CFR 0.152.
 */
package dev.speakeasyapi.sdk.client;

import dev.speakeasyapi.schemas.Ingest;
import dev.speakeasyapi.schemas.IngestServiceGrpc;
import dev.speakeasyapi.sdk.client.ISpeakeasyClient;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.stub.MetadataUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import org.springframework.util.StringUtils;

public class SpeakeasyClient
implements ISpeakeasyClient {
    private String authKey = "x-api-key";
    private Metadata.Key<String> metadataKey = Metadata.Key.of(this.authKey, Metadata.ASCII_STRING_MARSHALLER);
    private String apiKey;
    private String apiID;
    private String versionID;
    private String serverUrl;
    private boolean secureGrpc;

    public SpeakeasyClient(String apiKey, String apiID, String versionID, String serverUrl, boolean secureGrpc) throws IllegalArgumentException {
        this.validate(apiKey, apiID, versionID);
        this.apiKey = apiKey;
        this.apiID = apiID;
        this.versionID = versionID;
        this.serverUrl = serverUrl;
        this.secureGrpc = secureGrpc;
    }

    private void validate(String apiKey, String apiID, String versionID) throws IllegalArgumentException {
        if (!StringUtils.hasText(apiKey)) {
            throw new IllegalArgumentException("Speakeasy API key is required.");
        }
        int maxIDSize = 128;
        String validCharsRegexStr = "[^a-zA-Z0-9.\\-_~]";
        if (!StringUtils.hasText(apiID)) {
            throw new IllegalArgumentException("ApiID is required.");
        }
        if (apiID.length() > maxIDSize) {
            throw new IllegalArgumentException("ApiID must be less than " + maxIDSize + " characters.");
        }
        Pattern pattern = Pattern.compile(validCharsRegexStr);
        Matcher matcher = pattern.matcher(apiID);
        if (matcher.find()) {
            throw new IllegalArgumentException("ApiID contains invalid characters " + validCharsRegexStr);
        }
        if (!StringUtils.hasText(versionID)) {
            throw new IllegalArgumentException("VersionID is required.");
        }
        if (versionID.length() > maxIDSize) {
            throw new IllegalArgumentException("VersionID must be less than " + maxIDSize + " characters.");
        }
        pattern = Pattern.compile(validCharsRegexStr);
        matcher = pattern.matcher(versionID);
        if (matcher.find()) {
            throw new IllegalArgumentException("VersionID contains invalid characters " + validCharsRegexStr);
        }
    }

    @Override
    public void ingestGrpc(String harString, String pathHint, String customerID) throws StatusRuntimeException, SSLException {
        Metadata metadata = new Metadata();
        metadata.put(this.metadataKey, this.apiKey);
        Object channelBuilder = this.secureGrpc ? NettyChannelBuilder.forTarget(this.serverUrl).sslContext(GrpcSslContexts.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build()) : ManagedChannelBuilder.forTarget(this.serverUrl).usePlaintext();
        ManagedChannel channel = ((ManagedChannelBuilder)((ManagedChannelBuilder)channelBuilder).intercept(MetadataUtils.newAttachHeadersInterceptor(metadata))).build();
        IngestServiceGrpc.IngestServiceBlockingStub blockingStub = IngestServiceGrpc.newBlockingStub(channel);
        Ingest.IngestRequest.Builder ingestRequestBuilder = Ingest.IngestRequest.newBuilder().setHar(harString).setApiId(this.apiID).setVersionId(this.versionID).setPathHint(pathHint);
        if (customerID != null) {
            ingestRequestBuilder.setCustomerId(customerID);
        }
        Ingest.IngestRequest ingestRequest = ingestRequestBuilder.build();
        try {
            blockingStub.ingest(ingestRequest);
        }
        catch (StatusRuntimeException e) {
            throw e;
        }
        finally {
            channel.shutdown();
        }
    }
}

