package dev.speakeasyapi.sdk.utils;

import javax.servlet.*;
import javax.servlet.http.*;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;

public class SpeakeasyRequestWrapper implements HttpServletRequest {
    private class InputStreamWrapper extends ServletInputStream {
        private ServletInputStream wrapped;
        private ByteArrayOutputStream speakeasyOutputStream;

        public InputStreamWrapper(ServletInputStream wrapped) {
            this.wrapped = wrapped;
            this.speakeasyOutputStream = new ByteArrayOutputStream();
        }

        @Override
        public boolean isFinished() {
            return wrapped.isFinished();
        }

        @Override
        public boolean isReady() {
            return wrapped.isReady();
        }

        @Override
        public void setReadListener(ReadListener listener) {
            wrapped.setReadListener(listener);
        }

        @Override
        public int read() throws IOException {
            int value = wrapped.read();
            if (value != -1) {
                speakeasyOutputStream.write(value);
            }
            return value;
        }
    }

    public static String speakeasyOutputStringAttribute = "speakeasyOutputStream";
    private HttpServletRequest wrapped;
    private InputStreamWrapper inputStream;

    public SpeakeasyRequestWrapper(HttpServletRequest wrapped) throws IOException {
        this.wrapped = wrapped;
        this.inputStream = new InputStreamWrapper(wrapped.getInputStream());
    }

    @Override
    public String getAuthType() {
        return wrapped.getAuthType();
    }

    @Override
    public Cookie[] getCookies() {
        return wrapped.getCookies();
    }

    @Override
    public long getDateHeader(String name) {
        return wrapped.getDateHeader(name);
    }

    @Override
    public String getHeader(String name) {
        return wrapped.getHeader(name);
    }

    @Override
    public Enumeration<String> getHeaders(String name) {
        return wrapped.getHeaders(name);
    }

    @Override
    public Enumeration<String> getHeaderNames() {
        return wrapped.getHeaderNames();
    }

    @Override
    public int getIntHeader(String name) {
        return wrapped.getIntHeader(name);
    }

    @Override
    public String getMethod() {
        return wrapped.getMethod();
    }

    @Override
    public String getPathInfo() {
        return wrapped.getPathInfo();
    }

    @Override
    public String getPathTranslated() {
        return wrapped.getPathTranslated();
    }

    @Override
    public String getContextPath() {
        return wrapped.getContextPath();
    }

    @Override
    public String getQueryString() {
        return wrapped.getQueryString();
    }

    @Override
    public String getRemoteUser() {
        return wrapped.getRemoteUser();
    }

    @Override
    public boolean isUserInRole(String role) {
        return wrapped.isUserInRole(role);
    }

    @Override
    public Principal getUserPrincipal() {
        return wrapped.getUserPrincipal();
    }

    @Override
    public String getRequestedSessionId() {
        return wrapped.getRequestedSessionId();
    }

    @Override
    public String getRequestURI() {
        return wrapped.getRequestURI();
    }

    @Override
    public StringBuffer getRequestURL() {
        return wrapped.getRequestURL();
    }

    @Override
    public String getServletPath() {
        return wrapped.getServletPath();
    }

    @Override
    public HttpSession getSession(boolean create) {
        return wrapped.getSession(create);
    }

    @Override
    public HttpSession getSession() {
        return wrapped.getSession();
    }

    @Override
    public String changeSessionId() {
        return wrapped.changeSessionId();
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        return wrapped.isRequestedSessionIdValid();
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        return wrapped.isRequestedSessionIdFromCookie();
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        return wrapped.isRequestedSessionIdFromURL();
    }

    @Override
    public boolean isRequestedSessionIdFromUrl() {
        return wrapped.isRequestedSessionIdFromUrl();
    }

    @Override
    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return wrapped.authenticate(response);
    }

    @Override
    public void login(String username, String password) throws ServletException {
        wrapped.login(username, password);
    }

    @Override
    public void logout() throws ServletException {
        wrapped.logout();
    }

    @Override
    public Collection<Part> getParts() throws IOException, ServletException {
        return wrapped.getParts();
    }

    @Override
    public Part getPart(String name) throws IOException, ServletException {
        return wrapped.getPart(name);
    }

    @Override
    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
        return wrapped.upgrade(httpUpgradeHandlerClass);
    }

    @Override
    public Object getAttribute(String name) {
        if (speakeasyOutputStringAttribute.equals(name)) {
            return inputStream.speakeasyOutputStream;
        }
        return wrapped.getAttribute(name);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return wrapped.getAttributeNames();
    }

    @Override
    public String getCharacterEncoding() {
        return wrapped.getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        wrapped.setCharacterEncoding(env);
    }

    @Override
    public int getContentLength() {
        return wrapped.getContentLength();
    }

    @Override
    public long getContentLengthLong() {
        return wrapped.getContentLengthLong();
    }

    @Override
    public String getContentType() {
        return wrapped.getContentType();
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    @Override
    public String getParameter(String name) {
        return wrapped.getParameter(name);
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return wrapped.getParameterNames();
    }

    @Override
    public String[] getParameterValues(String name) {
        return wrapped.getParameterValues(name);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return wrapped.getParameterMap();
    }

    @Override
    public String getProtocol() {
        return wrapped.getProtocol();
    }

    @Override
    public String getScheme() {
        return wrapped.getScheme();
    }

    @Override
    public String getServerName() {
        return wrapped.getServerName();
    }

    @Override
    public int getServerPort() {
        return wrapped.getServerPort();
    }

    @Override
    public BufferedReader getReader() throws IOException {
        return wrapped.getReader();
    }

    @Override
    public String getRemoteAddr() {
        return wrapped.getRemoteAddr();
    }

    @Override
    public String getRemoteHost() {
        return wrapped.getRemoteHost();
    }

    @Override
    public void setAttribute(String name, Object o) {
        if (!speakeasyOutputStringAttribute.equals(name)) {
            wrapped.setAttribute(name, o);
        }
    }

    @Override
    public void removeAttribute(String name) {
        if (!speakeasyOutputStringAttribute.equals(name)) {
            wrapped.removeAttribute(name);
        }
    }

    @Override
    public Locale getLocale() {
        return wrapped.getLocale();
    }

    @Override
    public Enumeration<Locale> getLocales() {
        return wrapped.getLocales();
    }

    @Override
    public boolean isSecure() {
        return wrapped.isSecure();
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        return wrapped.getRequestDispatcher(path);
    }

    @Override
    public String getRealPath(String path) {
        return wrapped.getRealPath(path);
    }

    @Override
    public int getRemotePort() {
        return wrapped.getRemotePort();
    }

    @Override
    public String getLocalName() {
        return wrapped.getLocalName();
    }

    @Override
    public String getLocalAddr() {
        return wrapped.getLocalAddr();
    }

    @Override
    public int getLocalPort() {
        return wrapped.getLocalPort();
    }

    @Override
    public ServletContext getServletContext() {
        return wrapped.getServletContext();
    }

    @Override
    public AsyncContext startAsync() throws IllegalStateException {
        return wrapped.startAsync();
    }

    @Override
    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return wrapped.startAsync(servletRequest, servletResponse);
    }

    @Override
    public boolean isAsyncStarted() {
        return wrapped.isAsyncStarted();
    }

    @Override
    public boolean isAsyncSupported() {
        return wrapped.isAsyncSupported();
    }

    @Override
    public AsyncContext getAsyncContext() {
        return wrapped.getAsyncContext();
    }

    @Override
    public DispatcherType getDispatcherType() {
        return wrapped.getDispatcherType();
    }
}
