package dev.speakeasyapi.sdk.utils;

import java.io.ByteArrayOutputStream;
import java.util.Date;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.io.input.TeeInputStream;
import org.slf4j.Logger;
import org.springframework.web.servlet.HandlerInterceptor;

import dev.speakeasyapi.sdk.SpeakeasyRequestResponseHandler;
import dev.speakeasyapi.sdk.client.SpeakeasyClient;

public class SpeakeasyInterceptor implements HandlerInterceptor {
    private SpeakeasyRequestResponseHandler requestResponseHandler;
    private Date startTime;
    private Logger logger;

    public SpeakeasyInterceptor(String apiKey, String serverUrl, boolean secureGrpc, Logger logger) {
        this.logger = logger;
        requestResponseHandler = new SpeakeasyRequestResponseHandler(new SpeakeasyClient(apiKey, serverUrl, secureGrpc),
                logger);
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        startTime = new Date();
        return true;
    }

    @Override
    public void afterCompletion(HttpServletRequest req, HttpServletResponse res, Object handler, Exception ex) {
        new Thread(() -> {
            try {

                ByteArrayOutputStream requestOutputStream = null;
                ByteArrayOutputStream responseOutputStream = null;
                try {
                    responseOutputStream = ((SpeakeasyResponseWrapper) res).getSpeakeasyOutputStream();
                    requestOutputStream = (ByteArrayOutputStream) req.getAttribute(SpeakeasyRequestWrapper.speakeasyOutputStringAttribute);
                } catch (Exception e) {
                    logger.error("speakeasy-sdk:", e);
                }

                requestResponseHandler.captureRequestResponse(req, requestOutputStream,
                        res, responseOutputStream, startTime, new Date());
            } catch (Exception e) {
                logger.error("speakeasy-sdk:", e);
            }
        }).start();
    }
}
