package dev.speakeasyapi.sdk;

import dev.speakeasyapi.sdk.utils.SpeakeasyFilter;
import dev.speakeasyapi.sdk.utils.SpeakeasyInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConfigurationProperties(prefix = "speakeasy-api")
@ConfigurationPropertiesScan
@Import(SpeakeasyFilter.class)
public class EnableSpeakeasy implements WebMvcConfigurer {
    private String apiKey;

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    private String serverUrl = "grpc.prod.speakeasyapi.dev:443";

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    private boolean secureGrpc = true;

    public void setSecureGrpc(boolean secureGrpc) {
        this.secureGrpc = secureGrpc;
    }

    private Logger logger = LoggerFactory.getLogger(EnableSpeakeasy.class);


    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(new SpeakeasyInterceptor(apiKey, serverUrl, secureGrpc, logger));
    }
}
